<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Teri_Shop_Ecommerce
 */

get_header();
?>
<?php
    $post_id = get_the_ID();
    $thumbnail = get_theme_mod('crt_manage_single_thumbnail', 'outer-thumb');
    $args = teri_shop_ecommerce_archive_layout();
    $col_one = $args['col_one'];
    $col_two = $args['col_two'];
    $sidebar_position = $args['sidebar'];
    $related_layout = $args['layout'];
    $layout = get_theme_mod('crt_manage_single_sidebar', 'right-sidebar');
    if(get_post_format() == 'aside') {
        $layout = 'right-sidebar';
    }
    teri_shop_ecommerce_set_post_view_count($post_id);
?>
<main id="content" class="site-main single-<?php echo esc_attr($layout); ?>" itemscope="" itemtype="https://schema.org/CreativeWork">
    <?php do_action('teri_shop_ecommerce_single_header'); ?>

    <section class="block-content mt-4">
        <div class="container">
            <div class="">
                <div class="row">
                    <div class="<?php echo esc_attr($col_one); ?>">
                        <div class="single-detail__inner">
                        <?php
                        while ( have_posts() ) :
                            the_post();

                            get_template_part( 'template-parts/content', 'single' );

                            do_action('teri_shop_ecommerce_post_navigation');

                            do_action( 'teri_shop_ecommerce_author', $post );

                            // If comments are open or we have at least one comment, load up the comment template.
                            if ( comments_open() || get_comments_number() ) :
                                comments_template();
                            endif;

                            // Related Posts
                            if ( is_singular( 'post' ) ) {
                                $related_heading = get_theme_mod( 'crt_manage_single_related_heading', __( 'Related Posts','teri-shop-ecommerce' ) );
                                $grid = str_contains($related_layout, 'masonry');
                                $cat_content_id      = get_the_category( $post->ID )[0]->term_id;
                                $args                = array(
                                    'cat'            => $cat_content_id,
                                    'post__not_in'   => array( $post->ID ),
                                    'orderby'        => 'rand',
                                );
                                $query               = new WP_Query( $args );
                                if ( $query->have_posts() ) :
                                    ?>
                                    <div class="related-posts mt-4">
                                        <h2><?php echo esc_html( $related_heading ); ?></h2>
                                        <div class="<?php echo esc_attr($grid ? 'grid '.$related_layout:'row') ?>">
                                            <div class="grid__col-sizer"></div>
                                            <?php
                                                while ( $query->have_posts() ) :
                                                $query->the_post();
                                                get_template_part( 'template-parts/content', $related_layout );
                                                endwhile;
                                            ?>
                                        </div>
                                    </div>
                                    <?php
                                endif;
                                wp_reset_postdata();
                            }



                        endwhile; // End of the loop.
                        ?>
                        </div>
                    </div>
                    <div class="<?php echo esc_attr($col_two); ?>">
                        <?php if ($col_two != 'd-none'): ?>
                            <aside id="secondary" class="widget-area">
                                <?php
                                if ( is_active_sidebar( $sidebar_position ) ) {
                                    dynamic_sidebar( $sidebar_position );
                                }
                                ?>
                            </aside>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main><!-- #main -->

<?php
get_footer();
