<?php
    $enable_voucher = get_theme_mod('crt_manage_enable_voucher_section', false);
    $voucher_id = get_theme_mod('crt_manage_voucher_id');
    if(!$enable_voucher && isset($voucher_id[0])) {
        return;
    }
    $coupon = new WC_Coupon( $voucher_id[0] );
    if($coupon):
    wp_enqueue_style( 'teri-shop-ecommerce-voucher-1' );
    $description = get_post_meta($coupon->get_id(), 'crt_manage_coupon_description');
    $code = $coupon->get_code();
    $expiry_date = $coupon->get_date_expires();
    $formattedDate = date('F j, Y H:i:s', $expiry_date->getTimestamp());
?>
<section id="tse-voucher" class="tse-voucher mt-5 py-5">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="tse-voucher__inner">
                    <div class="tse-voucher__item">
                        <h2><?php echo esc_html($coupon->get_description()); ?></h2>
                    </div>
                    <div class="tse-voucher__item">
                        <div id="countdown" data-time="<?php echo esc_attr($formattedDate); ?>">
                            <div id="days" class="countdown__item"></div>
                            <div id="hours" class="countdown__item"></div>
                            <div id="minutes" class="countdown__item"></div>
                            <div id="seconds" class="countdown__item"></div>
                        </div>
                    </div>
                    <div class="tse-voucher__item">
                        <div>
                            <p><?php echo esc_html($description[0]); ?></p>
                            <span class="code"><?php echo esc_html($code); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>