<?php
    $enable_term_condition = get_theme_mod('crt_manage_enable_term_condition_section');
    if(!$enable_term_condition) {
        return;
    }
    $term_conditions = json_to_array(get_theme_mod('crt_manage_term_condition_list'));
    if(!empty($term_conditions)) :
    wp_enqueue_style( 'teri-shop-ecommerce-term-1' );
?>
<section class="term-condition">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="term-condition__inner d-flex flex-wrap">
                    <?php foreach ($term_conditions as $item): ?>
                        <div class="term-condition__item d-inline-flex align-items-center">
                            <i class="<?php echo esc_attr($item['icon_value']) ?>"></i>
                            <div class="term-condition__content">
                                <h3 class="term-condition__title"><?php echo esc_html($item['title']) ?></h3>
                                <div class="term-condition__text"><?php echo esc_html($item['subtitle']) ?></div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>