<?php
    $enable_slider = get_theme_mod('crt_manage_enable_slider_section');
    if(!$enable_slider) {
        return;
    }
    $slider_list = json_to_array(get_theme_mod('crt_manage_slider_list'));
    if(!empty($slider_list)) :
    wp_enqueue_style( 'teri-shop-ecommerce-slider-1' );
?>
<section class="tse-slider">
    <div class="tse-slider__inner tse-slider__js">
        <?php $c = 0; foreach ($slider_list as $item): $c++;
            $image_url = teri_shop_ecommerce_gtsicrf($item, 'teri-shop-ecommerce-image-medium', 'teri-shop-ecommerce-image-small');
        ?>
            <div class="tse-slider__item tse-slider__item-<?php echo esc_attr($c); ?>">
                <figure class="lazy ratio219" data-src="<?php echo esc_attr($image_url); ?>">
                    <div class="tse-slider__content">
                        <h2 class="tse-slider__title"><a href="<?php echo esc_url($item['link']); ?>"><?php echo esc_html($item['title']); ?></a></h2>
                        <div class="tse-slider__intro"><?php echo esc_html($item['text']); ?></div>
                    </div>
                </figure>
            </div>
        <?php endforeach; ?>
    </div>
</section>
<?php endif; ?>