<?php
    $enable_product = get_theme_mod('crt_manage_enable_product_section');
    $heading = get_theme_mod('crt_manage_product_headline', __( 'Weekly bestsellers', 'teri-shop-ecommerce' ));
    $product_list = get_theme_mod('crt_manage_product_list');
    $button_text = get_theme_mod('crt_manage_product_button_text', __( 'View All', 'teri-shop-ecommerce' ));
    $button_url = get_theme_mod('crt_manage_product_button_url', '#');

    $layout = get_theme_mod('crt_manage_product_layout', 'product-1');
    $post_on_row = get_theme_mod('crt_manage_product_on_row', 4);

    if(!$enable_product) {
        return;
    }
    wp_enqueue_style( 'teri-shop-ecommerce-' . $layout );
?>

<section id="product" class="product-1 padding-y-1">
    <div class="container position-relative">
        <?php crt_manage_section_link( 'Product' ); ?>
        <div class="col-12">
            <div class="heading-default d-flex justify-content-between align-items-center">
                <h2 class="heading-char-animation"><?php echo esc_html($heading); ?></h2>
                <span class="ms-auto"><a href="<?php echo esc_url($button_url); ?>"><?php echo esc_html($button_text); ?></a></span>
            </div>
            <?php get_template_part( 'woocommerce/' . $layout, '', array('list' => $product_list, 'post_on_row' => $post_on_row) ); ?>
        </div>
    </div>
</section>