<?php
    $enable_latest = get_theme_mod('crt_manage_enable_latest_section');
    if(!$enable_latest) {
        return;
    }
    $latest_post_per_page = get_theme_mod('crt_manage_latest_post_per_page', 2);
    $latest_post_order = get_theme_mod('crt_manage_latest_post_order', 'DESC');
    $sidebar_position = get_theme_mod('crt_manage_post_latest_sidebar_position', 'sidebar-1');
    $headline = get_theme_mod('crt_manage_latest_headline', __( 'Blog', 'teri-shop-ecommerce' ));
    $tax = get_theme_mod('crt_manage_latest_category_one_list');
    $button_text = get_theme_mod('crt_manage_latest_button_text', __( 'View All', 'teri-shop-ecommerce' ));
    $button_url = get_theme_mod('crt_manage_latest_button_url', '#');
?>

<section id="post-latest" class="post-latest mt-3 mt-md-4">
    <div class="container position-relative">
        <?php crt_manage_section_link( 'Post Latest' ); ?>
        <div class="">
            <div class="row ">
                <?php
                    $args = teri_shop_ecommerce_archive_layout();
                    $col_one = $args['col_one'];
                    $col_two = $args['col_two'];
                    $layout = $args['layout'];
                    $grid = str_contains($layout, 'masonry');
                ?>
                <div class="<?php echo esc_attr($col_one); ?>">
                    <div class="heading-default d-flex justify-content-between align-items-center">
                        <h2 class="heading-char-animation"><?php echo esc_html($headline); ?></h2>
                        <span class="ms-auto"><a href="<?php echo esc_url($button_url); ?>"><?php echo esc_html($button_text); ?></a></span>
                    </div>
                    <div>
                        <div class="<?php echo esc_attr($grid ? 'grid ' . $layout:'row') ?>">
                            <div class="grid__col-sizer"></div>
                            <?php
                                $paged = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
                                $args = array(
                                    'paged'          => $paged,
                                    'posts_per_page' => ( $latest_post_per_page ) ? $latest_post_per_page : 2,
                                    'order' => isset($latest_post_order[0]) ? $latest_post_order[0]:'DESC'
                                );
                                $loop = new WP_Query( $args );
                                if ( $loop->have_posts() ) :
                                    while ( $loop->have_posts() ) :
                                        $loop->the_post();
                                        get_template_part( 'template-parts/content', $layout, array('sidebar' => $col_two) );
                                    endwhile;
                                endif;
                                wp_reset_postdata();
                            ?>
                        </div>
                    </div>

                    <?php teri_shop_ecommerce_pagination_custom( $paged, $loop->max_num_pages); ?>
                </div>
                <div class="<?php echo esc_attr($col_two); ?>">
                    <?php if($col_two != 'd-none'): ?>
                        <aside id="secondary" class="widget-area">
                            <?php dynamic_sidebar( $sidebar_position ); ?>
                        </aside>
                    <?php endif; ?>
                </div>
                <?php if($col_two != 'd-none'): ?>
                    <div class="br-col br-col66 br-sm-col-none"></div>
                <?php endif; ?>
            </div>
        </div>

    </div>
</section>