<?php
    $sliders = json_to_array(get_theme_mod('crt_manage_hero_slider'));
?>
<?php if(!empty($sliders)): ?>
    <?php foreach ( $sliders as $slider_item ) :
        $image_url = teri_shop_ecommerce_gtsicrf($slider_item, 'teri-shop-ecommerce-image-large', 'teri-shop-ecommerce-image-small');
    ?>
        <div class="hero__item">
            <div class="position-relative">
                <img class="hero__thumbnail <?php echo esc_attr('ratio219'); ?>" data-lazy="<?php echo esc_attr($image_url); ?>" alt="<?php echo esc_attr(''); ?>" style="" />
                <div class="hero__content position-absolute">
                    <h3 class="hero__title"><?php echo esc_html($slider_item['title']); ?></h3>
                    <div class="hero__button">
                        <a href="<?php echo esc_url($slider_item['link']); ?>"><?php echo esc_html($slider_item['subtitle']); ?></a>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach;  ?>
<?php endif; ?>
