<?php
    $enable_faq = get_theme_mod('crt_manage_enable_faq_section');
    if(!$enable_faq) {
        return;
    }
    $heading = get_theme_mod('crt_manage_faq_heading',  __( 'Frequently Asked Questions', 'teri-shop-ecommerce' ));
    $faqs = json_to_array(get_theme_mod('crt_manage_faq_list'));
    if(!empty($faqs)) :
    wp_enqueue_style( 'teri-shop-ecommerce-faq-1' );
?>
<section class="tse-faq py-5">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h2 class="heading-char-animation heading-small"><?php echo esc_html($heading); ?></h2>
                <div class="tse-faq__inner ">
                    <?php
                        $c = 0;
                        foreach ($faqs as $item): $c++;
                        $content = html_entity_decode($item['text2']);
                    ?>
                        <div class="tse-faq__item <?php echo esc_attr($c == '1' ? 'active':''); ?>">
                            <h3 class="tse-faq__q"><?php echo esc_html($item['title']); ?><span class="icon-plus"></span></h3>
                            <div class="tse-faq__a"><?php echo wp_kses_post($content); ?></div>
                            <div class="tse-faq__line"></div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>



