<?php
    $enable_client = get_theme_mod('crt_manage_enable_client_section');
    if(!$enable_client) {
        return;
    }
    $client_list = json_to_array(get_theme_mod('crt_manage_client_list'));
    if(!empty($client_list)) :
    wp_enqueue_style( 'teri-shop-ecommerce-client-1' );
?>
<section class="tse-client py-5">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="tse-client__list tse-client__js d-flex">
                    <?php $c = 0; foreach ($client_list as $item): $c++; ?>
                        <div class="tse-client__item tse-client__item-<?php echo esc_attr($c); ?>">
                            <div class="tse-client__inner">
                                <div class="rating <?php echo esc_attr('rating-' . $item['field_type']); ?>">
                                    <?php for($i = 1; $i <= 5; $i++) { ?>
                                        <i class="fa-solid fa-star <?php echo esc_attr($i <= $item['field_type'] ? 'active':''); ?>"></i>
                                    <?php } ?>
                                </div>
                                <h2 class="tse-client__title"><?php echo esc_html($item['title']); ?></h2>
                                <div class="tse-client__content my-3"><?php echo esc_html($item['text']); ?></div>
                                <h3 class="tse-client__name"><?php echo esc_html($item['subtitle']); ?></h3>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>