<?php
    $tax = get_theme_mod('crt_manage_category_list');
    $on_row = get_theme_mod('crt_manage_category_slider_on_row', 4);
?>

<div class="category-2__list on-row-<?php echo esc_attr($on_row); ?>">
    <?php if(!empty($tax)): ?>
        <?php foreach ( $tax as $tax_id ) :
            $term = get_term($tax_id);
            $count = $term->count;
            $name = $term->name;
            $term_link = get_term_link($term);
            $thumbnail_id = get_term_meta($tax_id, 'thumbnail_id', true);
            $thumbnail_url = wp_get_attachment_image_src( $thumbnail_id, 'teri-shop-ecommerce-image-small' );
            ?>
            <div class="category-2__item">
                <a href="<?php echo esc_url($term_link); ?>">
                    <figure class="lazy ratio57" data-src="<?php echo esc_attr(isset($thumbnail_url[0]) ? $thumbnail_url[0]:''); ?>">
                        <div class="category-2__content">
                            <h3 class="category-2__name"><?php echo esc_html($name); ?></h3>
                        </div>
                    </figure>
                </a>
            </div>
        <?php endforeach;  ?>
    <?php endif; ?>
</div>