<?php
    $enable_category = get_theme_mod('crt_manage_enable_category_section');
    if(!$enable_category) {
        return;
    }
    $heading = get_theme_mod('crt_manage_category_headline', 'Trending Topics');
    $tax = get_theme_mod('crt_manage_category_list');
    $on_row = get_theme_mod('crt_manage_category_slider_on_row', 4);

    $layout = get_theme_mod('crt_manage_category_section_layout', 'category-1');
    wp_enqueue_style( 'teri-shop-ecommerce-' . $layout );
?>

<section id="topic-tax" class="<?php echo esc_attr($layout); ?>">
    <div class="container position-relative">
        <?php crt_manage_section_link( 'Category' ); ?>
        <div class="row">
            <div class="col-12">
                <?php get_template_part('sections/category/' . $layout, ''); ?>
            </div>
        </div>
    </div>
</section>