<?php
    $enable_carousel_text = get_theme_mod('crt_manage_enable_carousel_text_section');
    $carousel_text_speed = get_theme_mod('crt_manage_carousel_text_speed', '3');
    $carousel_text_icon = get_theme_mod('crt_manage_carousel_text_icon', 'fa-asterisk');
    if(!$enable_carousel_text) {
        return;
    }
    $carousel_text_list = json_to_array(get_theme_mod('crt_manage_carousel_text_list'));
    if(!empty($carousel_text_list)) :
    wp_enqueue_style( 'teri-shop-ecommerce-carousel-text' );
?>
<section class="tse-carousel-text">
    <div class="carousel-text carousel-text-<?php echo esc_attr($carousel_text_speed); ?>">
        <?php for($i = 0; $i <= 5; $i++): ?>
            <div class="carousel-text__item">
                <?php foreach ($carousel_text_list as $item): ?>
                    <span><?php echo esc_html($item['title']); ?></span>
                    <i class="fa-solid <?php echo esc_attr($carousel_text_icon); ?>"></i>
                <?php endforeach; ?>
            </div>
        <?php endfor; ?>
    </div>
</section>
<?php endif; ?>
