<?php
/**
 * Teri Shop Ecommerce functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Teri_Shop_Ecommerce
 */

if ( ! defined( 'TERI_SHOP_ECOMMERCE_VERSION' ) ) {
	define( 'TERI_SHOP_ECOMMERCE_VERSION', wp_get_theme()->get( 'Version' ) );
}
if ( ! defined( 'TERI_SHOP_ECOMMERCE_NAME' ) ) {
    define( 'TERI_SHOP_ECOMMERCE_NAME', wp_get_theme()->get( 'Name' ) );
}
if ( ! defined( 'TERI_SHOP_ECOMMERCE_URL_DEMO' ) ) {
    define( 'TERI_SHOP_ECOMMERCE_URL_DEMO', wp_get_theme()->get( 'ThemeURI' ) );
}

if ( ! function_exists( 'teri_shop_ecommerce_setup' ) ) :
    function teri_shop_ecommerce_setup() {

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        add_theme_support( 'title-tag' );

        add_theme_support( 'wp-block-styles' );

        add_theme_support( 'register_block_style' );

        add_theme_support( 'register_block_pattern' );

        add_theme_support( 'post-thumbnails' );

        add_theme_support( 'post-formats', array( 'quote', 'video', 'gallery', 'audio' ) );

        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support(
            'custom-logo',
            array(
                'height'      => 250,
                'width'       => 250,
                'flex-width'  => true,
                'flex-height' => true,
            )
        );

        add_theme_support( 'align-wide' );
        add_theme_support( 'responsive-embeds' );

        add_theme_support( 'html5', array(
            'comment-list',
            'comment-form',
            'search-form',
            'gallery',
            'caption',
        ) );

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(
            array(
                'primary' => esc_html__( 'Primary','teri-shop-ecommerce' ),
            )
        );
        register_nav_menus(
            array(
                'footer' => esc_html__( 'Footer','teri-shop-ecommerce' ),
            )
        );
    }
endif;
add_action( 'after_setup_theme', 'teri_shop_ecommerce_setup' );

add_image_size( 'teri-shop-ecommerce-image-small', 300, 9999 );
add_image_size( 'teri-shop-ecommerce-image-medium', 600, 9999 );
add_image_size( 'teri-shop-ecommerce-image-large', 1200, 9999 );

if ( ! function_exists( 'teri_shop_ecommerce_after_active' ) ) :
    function teri_shop_ecommerce_after_active() {
        $theme_active = get_option('stylesheet');

    }
endif;
add_action('after_switch_theme', 'teri_shop_ecommerce_after_active');


if ( ! function_exists( 'teri_shop_ecommerce_header_style' ) ) :
    /**
     * Styles the header image and text displayed on the blog.
     *
     * @see teri_shop_ecommerce_header_style().
     */
    function teri_shop_ecommerce_header_style() {
        $header_text_color = get_header_textcolor();

        /*
         * If no custom options for text are set, let's bail.
         * get_header_textcolor() options: Any hex value, 'blank' to hide text. Default: add_theme_support( 'custom-header' ).
         */
        if ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color ) {
            return;
        }

        // If we get this far, we have custom styles. Let's do this.
        ?>
        <style type="text/css">
            <?php
            // Has the text been hidden?
            if ( ! display_header_text() ) :
                ?>
            .site-title,
            .site-description {
                position: absolute;
                clip: rect(1px, 1px, 1px, 1px);
                color: red !important;
            }
            <?php
            // If the user has set a custom color for the text use that.
        else :
            ?>
            .site-title a,
            .site-description {
                color: #<?php echo esc_attr( $header_text_color ); ?>;
            }
            <?php endif; ?>
        </style>
        <?php
    }
endif;

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function teri_shop_ecommerce_content_width() {
    $GLOBALS['content_width'] = apply_filters( 'nmb_content_width', 640 );
}
add_action( 'after_setup_theme', 'teri_shop_ecommerce_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

function teri_shop_ecommerce_widget_registration($name, $id, $description,$beforeWidget, $afterWidget, $beforeTitle, $afterTitle){
    register_sidebar( array(
        'name' => $name,
        'id' => $id,
        'description' => $description,
        'before_widget' => $beforeWidget,
        'after_widget' => $afterWidget,
        'before_title' => $beforeTitle,
        'after_title' => $afterTitle,
    ));
}

function teri_shop_ecommerce_widgets_init() {
    teri_shop_ecommerce_widget_registration(esc_html__('Sidebar Front Page', 'teri-shop-ecommerce'), 'sidebar-1', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<section id="%1$s" class="widget %2$s">', '</section>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Sidebar Inner 2', 'teri-shop-ecommerce'), 'sidebar-2', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<section id="%1$s" class="widget %2$s">', '</section>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Sidebar Inner 3', 'teri-shop-ecommerce'), 'sidebar-3', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<section id="%1$s" class="widget %2$s">', '</section>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Sidebar Inner 4', 'teri-shop-ecommerce'), 'sidebar-4', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<section id="%1$s" class="widget %2$s">', '</section>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Sidebar Inner 5', 'teri-shop-ecommerce'), 'sidebar-5', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<section id="%1$s" class="widget %2$s">', '</section>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Sidebar Inner 6', 'teri-shop-ecommerce'), 'sidebar-6', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<section id="%1$s" class="widget %2$s">', '</section>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Sidebar E-Commerce', 'teri-shop-ecommerce'), 'sidebar-e-commerce', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<section id="%1$s" class="widget %2$s">', '</section>', '<h2 class="widget-title"><span>', '</span></h2>');

    teri_shop_ecommerce_widget_registration(esc_html__('Footer 1', 'teri-shop-ecommerce'), 'footer-1', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<div id="%1$s" class="footer %2$s">', '</div>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Footer 2', 'teri-shop-ecommerce'), 'footer-2', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<div id="%1$s" class="footer %2$s">', '</div>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Footer 3', 'teri-shop-ecommerce'), 'footer-3', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<div id="%1$s" class="footer %2$s">', '</div>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Footer 4', 'teri-shop-ecommerce'), 'footer-4', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<div id="%1$s" class="footer %2$s">', '</div>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Footer 5', 'teri-shop-ecommerce'), 'footer-5', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<div id="%1$s" class="footer %2$s">', '</div>', '<h2 class="widget-title"><span>', '</span></h2>');
    teri_shop_ecommerce_widget_registration(esc_html__('Footer Above', 'teri-shop-ecommerce'), 'footer-above', esc_html__('Add widgets here.', 'teri-shop-ecommerce'), '<div id="%1$s" class="footer %2$s">', '</div>', '<h2 class="widget-title"><span>', '</span></h2>');
}
add_action( 'widgets_init', 'teri_shop_ecommerce_widgets_init' );

/**
 * Count Widget Footer Active
 */
function teri_shop_ecommerce_footer_is_widget() {
    $widget_active = array();
    for($i = 1; $i < 5;$i++) {
        if(is_active_sidebar( 'footer-'.$i )) {
            $widget_active[$i] = $i;
        }
    }
    return $widget_active;
}

/**
 * Enqueue scripts and styles.
 */
function teri_shop_ecommerce_scripts() {

    wp_enqueue_style( 'teri-shop-ecommerce-style', get_template_directory_uri() . '/style.css', array(), TERI_SHOP_ECOMMERCE_VERSION );
    // Main style.
    wp_enqueue_style( 'teri-shop-ecommerce-main-style', get_template_directory_uri() . '/assets/build/css/main.min.css', array(), TERI_SHOP_ECOMMERCE_VERSION );

    // Main script.
    wp_enqueue_script( 'imagesloaded', '', array( ));
    wp_enqueue_script( 'jquery-masonry', '', array( 'jquery' ) );
    if(teri_shop_ecommerce_crt_is_active()) {
        wp_enqueue_script( 'crt-manage-lib-slick' );
        wp_enqueue_script( 'crt-manage-lib-modernizr' );
        wp_enqueue_script( 'crt-manage-lib-jquery-lazy' );
    } else {
        wp_enqueue_script( 'jquery-lazy', get_template_directory_uri() . '/assets/js/jquery.lazy.js', array(  ), TERI_SHOP_ECOMMERCE_VERSION, true  );
    }
    wp_enqueue_script( 'teri-shop-ecommerce-main-script', get_template_directory_uri() . '/assets/js/main.js', array( 'jquery' ), TERI_SHOP_ECOMMERCE_VERSION, true );

    if(teri_shop_ecommerce_crt_is_active()) {
        wp_enqueue_script( 'crt-manage-lib-infinite-scroll' );
        wp_enqueue_script( 'crt-manage-lib-gsap' );
        wp_enqueue_script( 'crt-manage-lib-scroll-trigger' );
        wp_enqueue_script( 'crt-manage-lib-split-text' );
        wp_enqueue_script( 'teri-shop-ecommerce-app-script', get_template_directory_uri() . '/assets/js/app.js', array(  ), TERI_SHOP_ECOMMERCE_VERSION, true );
    }


    // Text Carousel
    wp_register_style( 'teri-shop-ecommerce-carousel-text', get_template_directory_uri() . '/assets/css/layout/carousel-text.css', array(), TERI_SHOP_ECOMMERCE_VERSION );

    $register_style = array(
        'category' => 2,
        'product' => 3,
        'client' => 1,
        'faq' => 1,
        'slider' => 1,
        'text' => 1,
        'term' => 1,
        'voucher' => 1,
    );

    foreach ($register_style as $handle => $count) {
        $dir = $count > 1 ? $handle . '/' : '';
        for($number = 1; $number <= $count; $number++):
            wp_register_style( 'teri-shop-ecommerce-'. $handle .'-' . $number, get_template_directory_uri() . '/assets/css/layout/' . $dir .$handle.'-' . $number . '.css', array(), TERI_SHOP_ECOMMERCE_VERSION );
        endfor;
    }

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
    wp_add_inline_script( 'teri-shop-ecommerce-main-script', 'const TERI_SHOP_ECOMMERCE_SCRIPT = ' . teri_shop_ecommerce_script_inline(), 'before' );
}
add_action( 'wp_enqueue_scripts', 'teri_shop_ecommerce_scripts' );

function teri_shop_ecommerce_google_font_default() {
    $font_family = array(
        'Montserrat:300,regular,700',
        'Roboto:300,regular,700',
        'Oswald:300,regular,700',
    );
    $query_args = array(
        'family' => urlencode( implode( '|', $font_family ) ),
    );

    if ( ! empty( $font_family ) ) {
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
    return $fonts_url;
}

function teri_shop_ecommerce_dynamic_front_end_css() {
    $body_font = get_theme_mod('crt_manage_general_body_font', 'Montserrat');
    $heading_font = get_theme_mod('crt_manage_general_post_heading_font', 'Libre Caslon Display');
    $heading_transform = get_theme_mod('crt_manage_general_post_heading_transform', 'uppercase');
    $heading_weight = get_theme_mod('crt_manage_general_post_heading_weight', '700');
    $logo_font = get_theme_mod('crt_manage_header_logo_font', 'Libre Caslon Display');
    $nav_font = get_theme_mod('crt_manage_header_nav_font', 'Montserrat');
    $nav_transform = get_theme_mod('crt_manage_header_nav_transform', 'uppercase');
    $nav_font_size = get_theme_mod('crt_manage_header_nav_font_size', '18px');
    $nav_font_height = get_theme_mod('crt_manage_header_nav_size', '40px');

    $nav_logo_padding = get_theme_mod('crt_manage_header_logo_height', '50px');
    $nav_logo_size = get_theme_mod('crt_manage_header_logo_size', '76px');
    $nav_logo_transform = get_theme_mod('crt_manage_header_logo_transform', 'uppercase');
    $nav_logo_weight = get_theme_mod('crt_manage_header_logo_weight', '700');

    $nav_top_style = get_theme_mod('crt_manage_header_nav_top_style', 'border');
    $nav_top_bg = get_theme_mod('crt_manage_header_nav_top_style_bg_color', '#FFF');
    $nav_top_text_color = get_theme_mod('crt_manage_header_nav_top_color', '#000');
    $nav_top_border_color = get_theme_mod('crt_manage_header_nav_top_style_bd_color', '#000');
    $color_extra = get_theme_mod('crt_manage_general_extra_color', '#f1f1f1');
    $custom_css_front = '';
    $custom_css_front .= ' :root {
       --body-font: '. esc_attr( $body_font ) .';
       --heading-font: '. esc_attr( $heading_font ) .';
       --heading-weight: '. esc_attr( $heading_weight ) .';
       --heading-transfrom: '. esc_attr( $heading_transform ) .';
       
       --logo-font: '. esc_attr( $logo_font ) .';
       --logo-padding: '. esc_attr( $nav_logo_padding ) .' 0px;
       --logo-size: '. esc_attr( $nav_logo_size ) .';
       --logo-transform: '. esc_attr( $nav_logo_transform ) .';
       --logo-weight: '. esc_attr( $nav_logo_weight ) .';

       --header-nav-font: '. esc_attr( $nav_font ) .';
       --header-nav-transform: '. esc_attr( $nav_transform ) .';
       --header-nav-font-size: '. esc_attr( $nav_font_size ) .';
       --header-nav-height: '. esc_attr( $nav_font_height ) .';
       
       --header-nav-top-style: '. esc_attr( $nav_top_style ) .';
       --header-nav-top-bg: '. esc_attr( $nav_top_bg ) .';
       --header-nav-top-text-color: '. esc_attr( $nav_top_text_color ) .';
       --header-nav-top-border-color: '. esc_attr( $nav_top_border_color ) .';
       --color-extra: '.esc_attr( $color_extra ).';
       --plyr-color-main: #000;
    }';
    wp_register_style( 'teri-shop-ecommerce-style-inline', false );
    wp_enqueue_style( 'teri-shop-ecommerce-style-inline' );
    wp_add_inline_style( 'teri-shop-ecommerce-style-inline', $custom_css_front );

    if(!teri_shop_ecommerce_crt_is_active()) {
        wp_enqueue_style( 'teri-shop-ecommerce-google-fonts', wptt_get_webfont_url( teri_shop_ecommerce_google_font_default() ), array(), null );
    } else {
        wp_enqueue_style( 'teri-shop-ecommerce-google-fonts', wptt_get_webfont_url( crt_manage_teri_shop_ecommerce_fonts() ), array(), null );
    }
}
add_action( 'wp_enqueue_scripts', 'teri_shop_ecommerce_dynamic_front_end_css' );

/**
 * Include wptt webfont loader.
 */
require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Dynamic CSS
 */
require get_template_directory() . '/inc/dynamic-css.php';

/**
 * Breadcrumb
 */
require get_template_directory() . '/inc/class-breadcrumb-trail.php';

/**
 * Recommended Plugins
 */
require get_template_directory() . '/inc/tgmpa/recommended-plugins.php';

/**
 * Quick Setup
 */
require get_template_directory() . '/inc/class-quick-setup.php';

/**
 * Define script const
/**/
function teri_shop_ecommerce_script_inline() {
    $hero_type = get_theme_mod('crt_manage_hero_v1_type', 'v1');
    $slider_show = get_theme_mod('crt_manage_hero_v1_slider_on_row', '4');
    $slider_center_mode = get_theme_mod('crt_manage_enable_hero_v1_slider_center_mode', true);
    $slider_auto_play = get_theme_mod('crt_manage_enable_hero_v1_slider_auto_play', true);
    $slider_ratio = get_theme_mod('crt_manage_general_post_item_ratio', 'ratio57');
    $slider_fullwidth = get_theme_mod('crt_manage_enable_hero_v1_slider_full_width', true);

    $hero_item = false;
    $hero_show = 3;
    $hero_padding = '0';
    if($hero_type == 'v1') {
        $hero_item = true;
        $hero_show = 1;
        $slider_center_mode = false;
    } elseif($hero_type == 'v2') {
        $hero_item = false;
        $hero_show = 3;
        $slider_center_mode = false;
    } elseif($hero_type == 'v3') {
        $hero_item = false;
        $hero_show = 1;
        $hero_padding = '28%';
        if($slider_fullwidth) {
            $hero_show = 2;
            $hero_padding = '10%';
        }
        $slider_center_mode = true;
        if($slider_ratio == 'ratio57' || $slider_ratio == 'ratio11') {
            $hero_show = 2;
            $hero_padding = '10%';
        }
    }

    $script_inline = json_encode( array(
        'ajaxUrl' => admin_url( 'admin-ajax.php' ),
        'HERO_SLIDER_SHOW' => $slider_show,
        'HERO_SLIDER_CENTER_MODE' => $slider_center_mode,
        'HERO_SLIDER_CENTER_PADDING' => $hero_padding,
        'HERO_SLIDER_AUTO_PLAY' => $slider_auto_play,
        'COLOR_MAIN' => '#000',
        'HERO_SLIDER_ITEM_WIDTH' => $hero_item,
        'HERO_SLIDER_ON_ROW' => $hero_show,
        'SITE' => get_template_directory_uri(),
    ));
    return $script_inline;
}

/**
* Post View Count
/**/
function teri_shop_ecommerce_set_post_view_count($postID) {
    $countKey = 'post_view_count';
    $count = get_post_meta($postID, $countKey, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $countKey);
        add_post_meta($postID, $countKey, '1');
    }else{
        $count++;
        update_post_meta($postID, $countKey, $count);
    }
}

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
    require get_template_directory() . '/inc/jetpack.php';
}
/**
 * Woocommerce.
 */
if ( class_exists( 'WooCommerce' ) ) {
    require get_template_directory() . '/inc/woocommerce.php';
}

if ( ! function_exists( 'teri_shop_ecommerce_is_woocommerce' ) ) {
    function teri_shop_ecommerce_is_woocommerce() {
        if(class_exists( 'WooCommerce' )) {
            return true;
        }
        return false;
    }
}
/**
 * CRT Manage is active.
 */
if ( ! function_exists( 'teri_shop_ecommerce_crt_is_active' ) ) {
    function teri_shop_ecommerce_crt_is_active() {
        if(class_exists( 'CRT_Manage_Base' )) {
            return true;
        }
        return false;
    }
}
/**
 * Custom Heading Archive.
 */
add_filter('get_the_archive_title', function ($title) {
    $title  = __( 'Archives','teri-shop-ecommerce' );

    if ( is_category() ) {
        $title  = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title  = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title  = get_the_author();
    } elseif ( is_year() ) {
        /* translators: See https://www.php.net/manual/datetime.format.php */
        $title  = get_the_date( _x( 'Y', 'yearly archives date format','teri-shop-ecommerce' ) );
    } elseif ( is_month() ) {
        /* translators: See https://www.php.net/manual/datetime.format.php */
        $title  = get_the_date( _x( 'F Y', 'monthly archives date format','teri-shop-ecommerce' ) );
    } elseif ( is_day() ) {
        /* translators: See https://www.php.net/manual/datetime.format.php */
        $title  = get_the_date( _x( 'F j, Y', 'daily archives date format','teri-shop-ecommerce' ) );
    } elseif ( is_tax( 'post_format' ) ) {
        if ( is_tax( 'post_format', 'post-format-aside' ) ) {
            $title = _x( 'Asides', 'post format archive title','teri-shop-ecommerce' );
        } elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) {
            $title = _x( 'Galleries', 'post format archive title','teri-shop-ecommerce' );
        } elseif ( is_tax( 'post_format', 'post-format-image' ) ) {
            $title = _x( 'Images', 'post format archive title','teri-shop-ecommerce' );
        } elseif ( is_tax( 'post_format', 'post-format-video' ) ) {
            $title = _x( 'Videos', 'post format archive title','teri-shop-ecommerce' );
        } elseif ( is_tax( 'post_format', 'post-format-quote' ) ) {
            $title = _x( 'Quotes', 'post format archive title','teri-shop-ecommerce' );
        } elseif ( is_tax( 'post_format', 'post-format-link' ) ) {
            $title = _x( 'Links', 'post format archive title','teri-shop-ecommerce' );
        } elseif ( is_tax( 'post_format', 'post-format-status' ) ) {
            $title = _x( 'Statuses', 'post format archive title','teri-shop-ecommerce' );
        } elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {
            $title = _x( 'Audio', 'post format archive title','teri-shop-ecommerce' );
        } elseif ( is_tax( 'post_format', 'post-format-chat' ) ) {
            $title = _x( 'Chats', 'post format archive title','teri-shop-ecommerce' );
        }
    } elseif ( is_post_type_archive() ) {
        $title  = post_type_archive_title( '', false );
    } elseif ( is_tax() ) {
        $queried_object = get_queried_object();
        if ( $queried_object ) {
            $tax    = get_taxonomy( $queried_object->taxonomy );
            $title  = single_term_title( '', false );
        }
    }  elseif (is_search()) {
        $value = get_search_query();
        $title = sprintf( esc_html__( 'Search: %s','teri-shop-ecommerce' ), $value);
    } elseif (teri_shop_ecommerce_is_woocommerce()) {
        if (is_cart()) {
            $title = _x( 'Cart', 'post format archive title','teri-shop-ecommerce' );
        } elseif (is_checkout()) {
            $title = _x( 'Checkout', 'post format archive title','teri-shop-ecommerce' );
        }
    }
    return $title;
});