<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Teri_Shop_Ecommerce
 */

?>
<!-- start footer -->
<footer class="footer" itemscope="" itemtype="https://schema.org/WPFooter">
    <?php teri_shop_ecommerce_footer_instagram(); ?>
    <div></div>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="footer__inner">
                    <div class="row">
                        <?php
                            $widget_active = teri_shop_ecommerce_footer_is_widget();
                            $col = !empty($widget_active) ? 12/count($widget_active):12;
                        ?>
                        <?php if(!empty($widget_active)): ?>
                            <?php foreach($widget_active as $v): ?>
                                <div class="col-12 col-md-6 col-lg-<?php echo esc_attr($col); ?> mb-3">
                                    <?php dynamic_sidebar( 'footer-' . $v ); ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <?php
                                if(is_active_sidebar( 'footer-above' )) {
                                    dynamic_sidebar( 'footer-above' );
                                }
                            ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <?php
                            if ( has_nav_menu( 'footer' ) ) :
                                wp_nav_menu(
                                    array(
                                        'container' => false,
                                        'theme_location' => 'footer',
                                        'menu_class' => 'menu-bottom d-flex p-0 m-0 mt-4'
                                    )
                                );
                            endif;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<div id="progress"><span id="progress-value"><i class=""></i></span></div>
<!-- end footer -->

<?php wp_footer(); ?>



</body>
</html>
