<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Teri_Shop_Ecommerce
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
$teri_shop_ecommerce_comment_count = get_comments_number();

?>
<div class="comments-area__count">
    <?php if ( $teri_shop_ecommerce_comment_count > 0  ): ?>
        <a href="#comments" rel="nofollow"><?php printf( esc_html__( 'View Comments (%1$s)','teri-shop-ecommerce' ), $teri_shop_ecommerce_comment_count ); ?></a>
    <?php else: ?>
        <a href="#comments" rel="nofollow"><?php printf( esc_html__( '%1$s Write a Comment','teri-shop-ecommerce' ), '<i class="fa-solid fa-pencil"></i> ' ); ?></a>
    <?php endif; ?>
</div>
<div id="comments" class="comments-area">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>

		<?php the_comments_navigation(); ?>

		<ol class="comment-list">
			<?php
			wp_list_comments(
				array(
					'style'      => 'ol',
					'short_ping' => true,
				)
			);
			?>
		</ol><!-- .comment-list -->

		<?php
		the_comments_navigation();

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() ) :
			?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.','teri-shop-ecommerce' ); ?></p>
			<?php
		endif;

	endif; // Check for have_comments().

	comment_form();
	?>

</div><!-- #comments -->
