// Script write by CRThemes

document.addEventListener("DOMContentLoaded", function(event){
    window.addEventListener("load", function(e){
        gsap.registerPlugin(SplitText);
        const desktopAnimation = gsap.matchMedia();

        var tlSplitGreat = gsap.timeline({
            scrollTrigger: {
                trigger: '.tse-text',
                start: "top 50%",
                end: "top 30%",
                scrub: 1,
                toggleActions: "restart"
            }
        }),
        SplitGreat = new SplitText(".tse-text__content", {type:"words"}),
        chars = SplitGreat.words;

        tlSplitGreat.from(chars, {
            duration: 10,
            opacity:0,
            y: 10,
            ease:"circ.out",
            stagger: 0.5,
        }, "+=0");

        if(document.querySelector('.product-animation')) {
            const products = gsap.utils.toArray(".product-animation");
            products.forEach(product => {
                let product__item = product.querySelectorAll(".product__item, .product-2__item");
                let tl = gsap.timeline({
                    defaults: {
                        ease: "power1.out",
                        duration: .6
                    },
                    scrollTrigger: {
                        trigger: product,
                        start: "top 70%",
                        markers: false,
                        toggleActions: "restart"
                    }
                });
                product__item.forEach(element => {
                    tl.from(element, {
                        x: 20,
                        opacity: 0
                    });
                });
            });
        }

        var voucher = document.getElementById("tse-voucher");
        if(voucher) {
            gsap.from('.tse-voucher__inner', {
                scale: 1.2,
                opacity: 0,
                scrollTrigger: {
                    trigger: '.tse-voucher__inner',
                    start: "top 60%",
                    toggleActions: "restart"
                }
            });
        }

        if (document.querySelector('.heading-char-animation')) {
            let char_come = gsap.utils.toArray(".heading-char-animation");
            char_come.forEach((splitTextLine) => {
                const tl = gsap.timeline({
                    scrollTrigger: {
                        trigger: splitTextLine,
                        start: "top 90%",
                        end: "bottom 60%",
                        scrub: false,
                        markers: false,
                        toggleActions: "restart",
                    },
                });

                const itemSplitted = new SplitText(splitTextLine, {
                    type: "chars, words",
                });
                gsap.set(splitTextLine, { perspective: 300 });
                itemSplitted.split({ type: "chars, words" });
                tl.from(itemSplitted.chars, {
                    duration: 1,
                    delay: 0.5,
                    x: 50,
                    autoAlpha: 0,
                    stagger: 0.05,
                });
            });
        }

        if(document.querySelector('#player')) {
            setTimeout(function(){
                const player = new Plyr('#player', {
                    muted: true,
                    autoplay: true,
                });
                player.pause();
                gsap.from('#player', {
                    scrollTrigger: {
                        trigger: '#player',
                        start: "top 80%",
                        end: "bottom -60%",
                        toggleActions: "restart",
                        onEnter: () => {
                            player.play();
                        },
                        onEnterBack: () => {
                            player.play();
                        },
                        onLeave: () => {
                            player.pause();
                        },
                        onLeaveBack: () => {
                            player.pause();
                        },
                    }
                });
            }, 6000);
        }

        if (document.querySelector('.heading-char-animation')) {
            let tl2 = gsap.timeline({
                defaults: {
                    ease: "power1.out",
                    duration: .6
                },
                scrollTrigger: {
                    trigger: '.tse-faq__inner',
                    start: "top 60%",
                    end: "bottom 60%",
                    toggleActions: "restart",
                    scrub: 1,
                    ease: 'linear',
                }
            });

            const faq_item = gsap.utils.toArray(".tse-faq__inner .tse-faq__line");
            faq_item.forEach((element) => {
                tl2.to(element, {
                    width: '100%',
                });
            });
        }

        if (document.querySelector('.tse-client')) {
            let tl2 = gsap.timeline({
                defaults: {
                    ease: "power1.out",
                    duration: .6
                },
                scrollTrigger: {
                    trigger: '.tse-client__list',
                    start: "top 80%",
                    end: "bottom 90%",
                    toggleActions: "restart",
                    scrub: 1,
                    ease: 'linear',
                }
            });

            const client_item = gsap.utils.toArray(".tse-client__item");
            client_item.forEach((element) => {
                tl2.fromTo(element, {
                        xPercent: 10,
                        opacity: 0
                    },
                    {
                        xPercent: 0,
                        opacity: 1
                    }
                );
            });
        }

        if(document.querySelector('.archive.woocommerce')) {
            gsap.to('.button-filter-js', {
                scrollTrigger: {
                    trigger: '.tse-product-list',
                    start: "top 30%",
                    end: "bottom 70%",
                    toggleActions: "play pause resume reset",
                    // markers: true,
                    toggleClass: 'filter-active',
                }
            });
        }

        desktopAnimation.add("(min-width: 800px)", () => {
            if (document.querySelector('.topic-tax')) {
                let tl2 = gsap.timeline({
                    defaults: {
                        ease: "power1.out",
                        duration: .6
                    },
                    scrollTrigger: {
                        trigger: '.topic-tax',
                        start: "top 60%",
                        end: "bottom 95%",
                        toggleActions: "restart",
                        scrub: 1,
                        // markers: true,
                        ease: 'linear',
                    }
                });

                const tax_item = gsap.utils.toArray(".topic-tax__item");
                tax_item.forEach((element) => {
                    tl2.fromTo(element, {
                            rotation: 5,
                            opacity: 0
                        },
                        {
                            rotation: 0,
                            opacity: 1
                        }
                    );
                });
            }
        });

    }, false);

});
