<?php
    $post_id = get_the_ID();
    $is_excerpt = get_theme_mod('crt_manage_single_is_excerpt', true);
    $is_read = get_theme_mod('crt_manage_single_is_min_read', true);
    $is_comment = get_theme_mod('crt_manage_single_is_comment', true);
    $is_view = get_theme_mod('crt_manage_single_is_view', true);
    $is_author = get_theme_mod('crt_manage_single_is_author', true);
?>
<section class="single-header single-header__v4">
    <div class="container">
        <div class="single-page-heading border-left-right border-md-none border-sm-none">
            <div class="row">
                <div class="col-12 col-md-6 text-center py-5 py-md-0">
                    <div class="single-heading-default d-flex flex-column justify-content-center h-100">
                        <?php tenzin_news_magazine_entry_options(get_post($post_id), array('class' => 'd-flex justify-content-center mt-0 mb-2', 'entry_date' => true, 'entry_cat' => true, 'entry_author' => false, 'entry_read_time' => false, 'entry_comment' => false, 'entry_view_count' => false)); ?>
                        <?php the_title( '<h1 class="single-heading-default__title text-center">', '</h1>' ); ?>
                        <?php
                            $entry_date_format = get_theme_mod('crt_manage_entry_date_format', 'F d, Y');
                            $date = date($entry_date_format, strtotime(get_the_date()));
                        ?>
                        <?php if($is_excerpt): ?>
                            <div class="single-entry__excerpt text-center mx-auto mb-3">
                                <?php echo get_the_excerpt($post_id); ?>
                            </div>
                        <?php endif; ?>
                        <?php tenzin_news_magazine_entry_options(get_post($post_id), array('class' => 'mt-2 mb-3 d-flex justify-content-center flex-wrap', 'entry_date' => false, 'entry_cat' => false, 'entry_author' => $is_author, 'entry_read_time' => $is_read, 'entry_comment' => $is_comment, 'entry_view_count' => $is_view)); ?>
                    </div>
                </div>
                <div class="col-12 col-md-6">
                    <?php
                    $get_thumbnail_url = get_the_post_thumbnail_url($post_id);
                    ?>
                    <img class="lazy" data-src="<?php echo esc_attr($get_thumbnail_url); ?>" alt="<?php echo get_the_title(); ?>" />
                </div>
            </div>
        </div>
    </div>
</section>