<?php
    $post_id = get_the_ID();
    $is_excerpt = get_theme_mod('crt_manage_single_is_excerpt', true);
    $is_read = get_theme_mod('crt_manage_single_is_min_read', true);
    $is_comment = get_theme_mod('crt_manage_single_is_comment', true);
    $is_view = get_theme_mod('crt_manage_single_is_view', true);
    $is_author = get_theme_mod('crt_manage_single_is_author', true);
?>
<section class="single-header single-header__v1">
    <div class="container">
        <div class="single-page-heading border-left-right border-md-none border-sm-none">
            <div class="row">
                <div class="col-12">
                    <?php tenzin_news_magazine_post_thumbnail(); ?>
                </div>
                <div class="col-12 text-center pt-2">
                    <div class="breadcrumb-option mt-3">
                        <?php do_action('tenzin_news_magazine_breadcrumb'); ?>
                    </div>
                </div>
                <div class="col-12">
                    <div class="single-heading-default pb-2">
                        <?php the_title( '<h1 class="single-heading-default__title text-center">', '</h1>' ); ?>
                        <?php
                            $entry_date_format = get_theme_mod('crt_manage_entry_date_format', 'F d, Y');
                            $date = date($entry_date_format, strtotime(get_the_date()));
                        ?>
                        <?php if($is_excerpt): ?>
                        <div class="single-entry__excerpt text-center mx-auto mb-3">
                            <?php echo get_the_excerpt($post_id); ?>
                        </div>
                        <?php endif; ?>
                        <?php tenzin_news_magazine_entry_options(get_post($post_id), array('class' => 'mt-2 mb-3 d-flex justify-content-center flex-wrap', 'entry_date' => true, 'entry_cat' => true, 'entry_author' => $is_author, 'entry_read_time' => $is_read, 'entry_comment' => $is_comment, 'entry_view_count' => $is_view)); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>