<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Tenzin_News_Magazine
 */
?>
<?php
$social_icon_is_black = false;
$header_socials = json_to_array(get_theme_mod('crt_manage_header_social'));
$header_social_style = get_theme_mod('crt_manage_header_social_style');
$header_type = get_theme_mod('crt_manage_header_type');

if(!empty($args['style'])) {
    $header_social_style = $args['style'];
}
if(isset($args['black'])) {
    if($args['black']) {
        $social_icon_is_black = true;
    }
}
?>
<div class="head__social text-center text-md-start m-auto m-md-0 <?php echo esc_attr($args['class']); ?>">
    <?php
    if(!empty($header_socials)) : ?>
        <ul class="head__social--list <?php echo esc_attr('head__social--' . $header_social_style); ?> <?php echo esc_attr($args['class']); ?> m-0">
            <?php foreach ( $header_socials as $item ): ?>
                <li class="">
                    <?php
                        $css_attrs = '';
                        if($header_social_style == 'bg-color') {
                            $css_attrs = 'background-color: '.$item['color'].';border-radius: 50%;';
                        } elseif ($header_social_style == 'color') {
                            $css_attrs = 'color: '.$item['color'].';border-radius: 50%;';
                        } elseif ($header_social_style == 'none-border-solid') {
                            $css_attrs = 'color: #000;';
                            if($header_type == 'v5') {
                                $css_attrs = 'color: var(--header-nav-color, var(--header-nav-color-df))';
                            }
                            if($social_icon_is_black) {
                                $css_attrs = 'color: #000;';
                            }
                        } elseif ($header_social_style == 'border-line-solid') {
                            $css_attrs = 'border: 1px solid #000;color: #000;border-radius: 50%;';
                            if($header_type == 'v5') {
                                $css_attrs = 'border: 1px solid;color: var(--header-nav-color, var(--header-nav-color-df));border-radius: 50%;';
                            }
                            if($social_icon_is_black) {
                                $css_attrs = 'border: 1px solid;color: #000;border-radius: 50%;';
                            }
                        }
                    ?>
                    <a style="<?php echo esc_attr($css_attrs); ?>" class="" href="<?php echo esc_attr($item['link']) ?>" target="_blank" rel="alternate" title="<?php echo esc_attr($item['icon_value']) ?>">
                        <i class="fa-brands <?php echo esc_attr($item['icon_value']) ?>"></i>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>