<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Tenzin_News_Magazine
 */
?>
<?php
    $attr_color = '#000;';
    $header_nav_style = get_theme_mod('crt_manage_header_nav_style');
    $header_bg_color = get_theme_mod('crt_manage_header_nav_style_bg_color', 'black');
    $header_bd_color = get_theme_mod('crt_manage_header_nav_style_bd_color', 'black');
    $header_type = get_theme_mod('crt_manage_header_type');
    $header_fullwidth = get_theme_mod('crt_manage_header_nav_full_width');
    if($header_nav_style == 'bg-color' && $header_type != 'v3') {
        $attr_color = '#FFF';
    }
    $header_attrs = 'head__nav--'.$header_nav_style . ' head__bg--'.$header_bg_color.' head__bd--'.$header_bd_color;
?>
<?php if(!$header_fullwidth): ?><div class="container"><div class="row align-items-center"><div class="col-12"><?php endif; ?>
    <div class="head__nav <?php echo esc_attr($header_attrs); ?>">
        <nav class="nav__desktop" role="navigation" itemscope itemtype="https://schema.org/SiteNavigationElement">
            <?php
            if ( has_nav_menu( 'primary' ) ) {
                wp_nav_menu(
                    array(
                        'container' => false,
                        'theme_location' => 'primary',
                    )
                );
            } else {
                echo '<ul><li style="color: '.$attr_color.'">'.sprintf(__('Go to <a href="%s">Appearance > Menu</a> to set "Primary Menu"','tenzin-news-magazine'),get_admin_url('','nav-menus.php')).'</li></ul>';
            }
            ?>
        </nav>
    </div>
<?php if(!$header_fullwidth): ?></div></div></div><?php endif; ?>