<?php
    $type = get_theme_mod('crt_manage_header_search_type', 'v1');
    $label = get_theme_mod('crt_manage_header_search_label', 'Or check our Popular Categories...');
    $hide_category = get_theme_mod('crt_manage_header_search_hide_tax', true);
?>
<div class="form-search <?php echo esc_attr($type); ?>">
    <div class="form-search__inner">
        <a class="btn-search-close" href="#" aria-label="Close Search" rel="nofollow">
            <i class="fa-solid fa-xmark"></i>
            <label><?php esc_html_e( 'Press ESC to close','tenzin-news-magazine' ); ?></label>
        </a>
        <?php get_search_form(); ?>

        <?php if($hide_category): ?>
            <div class="form-search__reference">
                <h3><?php echo esc_html($label); ?></h3>
                <?php
                $terms = get_terms( array(
                    'taxonomy'   => 'category',
                    'hide_empty' => false,
                ) );
                ?>
                <?php if (!empty($terms)): ?>
                    <ul>
                        <?php foreach ($terms as $t): ?>
                            <li><a href="<?php echo esc_attr(get_term_link($t)); ?>"><?php echo esc_html($t->name); ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

