<?php
$locale = get_locale();
$time_zone = wp_timezone_string();
$date_format = get_option('date_format');
$header_date_format = get_theme_mod('crt_manage_header_right_date_format', 'd MMMM y');
$is_intl = true;
if (!extension_loaded("intl")) {
    $is_intl = false;
}
if($is_intl) {
    $time_zone = preg_replace_callback( '/^([+-])(\d{2}):\d{2}$/', function( $m ) { return 'Etc/GMT' . $m[1] . intval( $m[2] ); }, $time_zone );
    $week = new IntlDateFormatter(
        $locale,
        IntlDateFormatter::NONE,
        IntlDateFormatter::NONE,
        $time_zone,
        IntlDateFormatter::GREGORIAN,
        'EEEE'
    );
    $week = $week->format(time());

    $date = new IntlDateFormatter(
        $locale,
        IntlDateFormatter::NONE,
        IntlDateFormatter::NONE,
        $time_zone,
        IntlDateFormatter::GREGORIAN,
        $header_date_format
    );
    $date = $date->format(time());
} else {
    date_default_timezone_set($time_zone);
    $week = date("l");
    $date = date($date_format);
}
$header_vol_value = get_theme_mod('crt_manage_header_right_vol', 'Vol <strong>19</strong>');
?>
<div class="head__datetime flex-column mb-0 <?php echo esc_attr($args['class']); ?>">
    <h2 class="head__date--the"><?php echo $week; ?></h2>
    <div class="head__date--day">
        <span><?php echo $date; ?></span>
        <span><?php echo $header_vol_value ?></span>
    </div>
</div>


