<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Tenzin_News_Magazine
 */
?>
<?php
$class_header = '';
$header_container = false;
$header_type = get_theme_mod('crt_manage_header_type');
if($header_type) {
    $class_header .= 'header__' . $header_type;
}
$header_container = get_theme_mod('crt_manage_header_nav_full_width');
$class_header .=  $header_container ? ' header__fullwidth':' header__inner';
$header_nav_style = get_theme_mod('crt_manage_header_nav_style');
if($header_nav_style) {
//    $class_header .= ' header__' . $header_nav_style;
}
?>
<header class="head <?php echo esc_attr($class_header); ?>">
    <div class="head__row <?php echo esc_attr($header_container ? 'head__bg':''); ?>">
        <div class="container">
            <div class="border-left-right <?php echo esc_attr(!$header_container ? 'head__bg pe-lg-4 ps-lg-4 pe-md-3 ps-md-3':''); ?>  p-0 border-md-none border-sm-none">
                <div class="<?php echo esc_attr(!$header_container ? 'row':''); ?> d-none d-md-block">
                    <div class="col-md-12">
                        <div class="d-flex justify-content-between">
                            <div class="d-inline-flex align-items-center">
                                <?php get_template_part( 'template-parts/header/header-left' ); ?>
                            </div>
                            <div class="head__nav">
                                <?php get_template_part( 'template-parts/header-nav' ); ?>
                            </div>
                            <div class="d-flex justify-content-end align-items-center">
                                <?php get_template_part('template-parts/header/header-right'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="head__row">
        <div class="container">
            <div class="border-left-right <?php echo esc_attr(!$header_container ? '':''); ?>  p-0 border-md-none border-sm-none">
                <div class="row align-items-center">
                    <div class="col-2 col-md-auto">
                        <div class="d-inline-flex d-md-none">
                            <?php get_template_part('template-parts/header/header-left', '', array('show_nav_button' => true, 'show_search' => false, 'show_search_m' => false, 'show_social' => false, 'show_social_m' => false, 'show_date' => false, 'show_date_m' => false, 'color_search_black' => true, 'color_nav_black' => true)); ?>
                        </div>
                    </div>
                    <div class="col-8 col-md-12">
                        <?php get_template_part( 'template-parts/header/header-logo' ); ?>
                    </div>
                    <div class="col-2 col-md-auto">
                        <div class="d-inline-flex d-md-none head__right">
                            <?php get_template_part('template-parts/header/header-right', '', array('show_date' => false, 'show_date_m' => false, 'color_search_black' => true, 'color_nav_black' => true)); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php get_template_part( 'template-parts/header/header-side' ); ?>
    <?php get_template_part( 'template-parts/header/header-form-search' ); ?>
</header>
