<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Tenzin_News_Magazine
 */
?>
<?php
$class_header = '';
$header_container = false;
$header_type = get_theme_mod('crt_manage_header_type');
if($header_type) {
    $class_header .= 'header__' . $header_type;
}
$header_container = false;
$class_header .=  $header_container ? ' header__fullwidth':' header__inner';
$header_nav_style = get_theme_mod('crt_manage_header_nav_style');
?>
<header class="head <?php echo esc_attr($class_header); ?>">
    <div class="head__row d-none d-md-block">
        <div class="<?php echo esc_attr(!$header_container ? 'container':''); ?>">
            <div class="border-left-right <?php echo esc_attr(!$header_container ? 'pe-lg-4 ps-lg-4 pe-md-3 ps-md-3':''); ?>  p-0 border-md-none border-sm-none">
                <div class="<?php echo esc_attr(!$header_container ? 'row':''); ?>">
                    <div class="col-12">
                        <div class="py-1 border-bottom border-dark">
                            <div class="d-flex align-items-center justify-content-end">
                                <div class="head__nav me-auto d-none d-md-block">
                                    <?php get_template_part( 'template-parts/header-nav' ); ?>
                                </div>
                                <div class="head__right">
                                    <?php get_template_part('template-parts/header/header-right', '', array('show_date' => false)); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="head__row">
        <div class="container">
            <div class="border-left-right <?php echo esc_attr(!$header_container ? 'pe-lg-4 ps-lg-4 pe-md-3 ps-md-3':''); ?>  p-0 border-md-none border-sm-none">
                <div class="row align-items-center">
                    <div class="col-2 col-md-auto">
                        <div class="d-inline-flex d-md-none">
                            <?php get_template_part('template-parts/header/header-left', '', array('show_nav_button' => true, 'show_search' => false, 'show_search_m' => false, 'show_social' => false, 'show_social_m' => false, 'show_date' => false, 'show_date_m' => false)); ?>
                        </div>
                    </div>
                    <div class="col-8 col-md-12">
                        <?php get_template_part( 'template-parts/header/header-logo' ); ?>
                    </div>
                    <div class="col-2 col-md-auto">
                        <div class="d-inline-flex d-md-none head__right">
                            <?php get_template_part('template-parts/header/header-right', '', array('show_date' => false)); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php get_template_part( 'template-parts/header/header-side' ); ?>
    <?php get_template_part( 'template-parts/header/header-form-search' ); ?>
</header>
