<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Tenzin_News_Magazine
 */
?>
<?php
$class_header = '';
$header_container = false;
$header_type = get_theme_mod('crt_manage_header_type');
if($header_type) {
    $class_header .= 'header__' . $header_type;
}
?>
<header class="head <?php echo esc_attr($class_header); ?>">
    <div class="header__row">
        <div class="container">
            <div class="border-left-right <?php echo esc_attr(!$header_container ? ' pe-lg-4 ps-lg-4 pe-md-3 ps-md-3 p-0 border-md-none border-sm-none':''); ?>">
                <div class="row align-items-center">
                    <div class="col-9 col-md-3">
                        <?php get_template_part( 'template-parts/header/header-logo' ); ?>
                    </div>
                    <div class="col-3 col-md-9">
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex align-items-center justify-content-end">
                                    <div class="head__nav d-none d-md-block">
                                        <?php get_template_part( 'template-parts/header-nav' ); ?>
                                    </div>
                                    <?php get_template_part('template-parts/header/header-right'); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <?php get_template_part( 'template-parts/header/header-side' ); ?>
    <?php get_template_part( 'template-parts/header/header-form-search' ); ?>
</header>
