<?php
    $enable_category = get_theme_mod('crt_manage_enable_category_section');
    if(!$enable_category) {
        return;
    }
    $enable_heading = get_theme_mod('crt_manage_category_is_headline', false);
    $headline = get_theme_mod('crt_manage_category_headline', 'Trending Topics');
    $headline_sub = get_theme_mod('crt_manage_category_headline_sub', 'Trending Topics');
    $layout = get_theme_mod('crt_manage_the_category_layout', 'tax-1');
?>

<section id="s-category" class="s-category">
    <div class="container position-relative">
        <?php crt_manage_section_link( 'Category' ); ?>
        <div class="border-left-right p-lg-4 p-md-3 p-0 border-md-none border-sm-none">
            <div class="row">
                <div class="col-12">
                    <?php
                        if($enable_heading):
                            tenzin_news_magazine_heading($headline, $headline_sub, '', $enable_heading);
                        endif;
                    ?>
                    <?php get_template_part( 'sections/tax/'. $layout, '' ); ?>
                </div>
            </div>
        </div>
    </div>
</section>
