<?php
    $tax = get_theme_mod('crt_manage_category_list');
    $tax = array_slice($tax, 0, 4);
?>
<?php
    if(!empty($tax)):
    wp_enqueue_style( 'tenzin-news-magazine-tax-3' );
?>
<div class="tax-3__list">
    <?php foreach ( $tax as $tax_id ) :
        $term = get_term($tax_id);
        $count = $term->count;
        $name = $term->name;
        $term_link = get_term_link($term);
        $thumbnail_url = get_term_meta($tax_id, 'crt_manage_tax_image', true);
    ?>
        <div class="tax-3__item">
            <figure class="lazy ratio11" data-src="<?php echo esc_attr($thumbnail_url); ?>">
                <div class="tax-3__content">
                    <h3 class="tax-3__name"><a href="<?php echo esc_attr($term_link); ?>"><?php echo esc_html($name); ?></a></h3>
                </div>
            </figure>
        </div>
    <?php endforeach;  ?>
</div>
<?php endif; ?>
