<?php
    $prefix_field = 'crt_manage_post_tax_';
?>
<?php for($cc = 1; $cc <= 5; $cc++): ?>
<?php
    // Check enable
    if(get_theme_mod($prefix_field . $cc . '_enable')):
        // Fields in theme.
        $tax = get_theme_mod($prefix_field . $cc);
        if(!empty($tax[0])) :
            $headline_enable = get_theme_mod($prefix_field . $cc . '_headline_enable');
            $headline = get_theme_mod($prefix_field . $cc . '_headline');
            $layout = get_theme_mod($prefix_field . $cc . '_layout', 'layout-1');
            $headline_sub = get_theme_mod($prefix_field . $cc . '_headline_sub', '');

            $bg = get_theme_mod($prefix_field . $cc . '_bg_color', '');
            $color_text = get_theme_mod($prefix_field . $cc . '_color', '');

            $number_posts = 3;
            if($layout == 'layout-2' || $layout == 'layout-4' || $layout == 'layout-7' || $layout == 'layout-12') {
                $number_posts = 4;
            } elseif($layout == 'layout-3' || $layout == 'layout-5' || $layout == 'layout-8') {
                $number_posts = 5;
            } elseif($layout == 'layout-6') {
                $number_posts = 1;
            } elseif($layout == 'layout-1') {
                $number_posts = 1;
            } elseif($layout == 'layout-11') {
                $number_posts = 10;
            }
            $post_ids = get_posts(array('numberposts' => $number_posts, 'category' => !empty($tax[0]) ? $tax[0]:array(), 'fields' => 'ids'));
            $term = get_term($tax[0]);
            $term_link = get_term_link($term);
            $color = get_term_meta($term->term_id, 'crt_manage_tax_color');
            $headline = $headline ? $headline : $term->name;

            $style_attr = '';
            if($bg && $color_text) {
                $style_attr = 'background-color: '.$bg.'; color: '.$color_text.'; --bg-heading: '.$bg.'; --tag-a: ' . $color_text .'; --tag-a-hover: ' . $color_text .'; --primary-entry-text-color: ' . $color_text .';--heading-line-color: '.$color_text.';';
            }
            $hide_all_heading = true;
            if(!empty($bg) && !$headline_enable) {
                $hide_all_heading = false;
            }
?>
        <section id="layout-<?php echo esc_attr($cc); ?>" style="<?php echo esc_attr($style_attr); ?>">
            <div class="container position-relative">
                <div class="border-left-right p-lg-4 p-md-3 p-0 border-md-none border-sm-none">
                    <div class="row">
                        <div class="col-12">
                            <?php if($hide_all_heading) : tenzin_news_magazine_heading($headline, $headline_sub, $term_link, $headline_enable); endif; ?>
                            <?php get_template_part( 'sections/layout/'. $layout, '', array('posts' => $post_ids) ); ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <?php endif; ?>
<?php endfor; ?>

