<?php
$posts = $args['posts'];
?>
<?php
if(!empty($posts)):
    wp_enqueue_style( 'tenzin-news-magazine-layout-12' );
    ?>
        <div class="ly-12">
        <div class="row bor-col-d">
            <div class="col-12">
                <div class="ly-12__list">
                    <?php
                    foreach ( $posts as $post_id ) :
                        $post = get_post( $post_id );
                        $get_permalink = get_permalink( $post );
                        $title = $post->post_title;
                        $get_thumbnail_url = get_the_post_thumbnail_url( $post, 'tenzin-news-magazine-image-small');
                        ?>
                        <div class="ly-12__item mb-3 text-center">
                            <a href="<?php echo esc_html($get_permalink); ?>">
                                <figure class="lazy ratio11" data-src="<?php echo esc_html($get_thumbnail_url); ?>"></figure>
                            </a>
                            <div class="entry mb-2">
                                <?php tenzin_news_magazine_entry_options($post, array('class' => 'mt-3 justify-content-center', 'entry_date' => true, 'entry_cat' => true, 'entry_author' => false, 'entry_read_time' => false, 'entry_comment' => false, 'entry_view_count' => false)); ?>
                            </div>
                            <h3 class="ly-12__title mt-2 mb-1"><a href="<?php echo esc_html($get_permalink); ?>"><?php echo esc_html($title); ?></a></h3>
                            <div class="default-excerpt">
                                <?php echo get_the_excerpt($post_id); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        </div>
    </div>
<?php endif; ?>
