<?php
    $posts = $args['posts'];
?>

<?php if(!empty($posts)): ?>
    <?php
        wp_enqueue_style( 'tenzin-news-magazine-layout-1' );
    ?>
    <div class="ly-1">
        <div class="ly-1__inner">
            <div class="row">
        <?php
        $c = 0;
        foreach ( $posts as $post_id ) :
            $c++; $post = get_post( $post_id );
            $get_permalink = get_permalink( $post );
            $get_thumbnail_url = get_the_post_thumbnail_url( $post, 'tenzin-news-magazine-image-medium');
            $title = $post->post_title;
        ?>
            <div class="col-12 ly-1__item">
                <figure class="image-default lazy ratio32" data-src="<?php echo esc_html($get_thumbnail_url); ?>">
                    <div class="ly-1__content">
                        <div class="entry mb-2">
                            <?php tenzin_news_magazine_entry_options($post, array('class' => 'mt-4 mt-md-2', 'entry_date' => true, 'entry_cat' => true, 'entry_author' => false, 'entry_read_time' => false, 'entry_comment' => false, 'entry_view_count' => false)); ?>
                        </div>
                        <h3 class="ly-1__title"><a href="<?php echo esc_html($get_permalink); ?>"><?php echo get_the_title() ?></a></h3>
                        <div class="default-excerpt">
                            <?php echo tenzin_news_magazine_excerpt_custom(30, $post_id); ?>
                        </div>
                        <div class="ly-1__btn mt-3 mt-md-5">
                            <a href="<?php echo esc_attr($get_permalink); ?>"><?php esc_html_e('Read More', 'tenzin-news-magazine') ?></a>
                        </div>
                    </div>
                </figure>
            </div>
        <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>