<?php
    $slider_post = get_theme_mod('crt_manage_hero_v1_left_post');
    $slider_post = array_slice($slider_post, 0, 1);
    $slider_thumbnail = 'ratio57';
    $slider_nav_style = get_theme_mod('crt_manage_hero_v1_nav_style', 'square');
?>
<div class="col-md-12 mb-md-0 mb-3" style="--primary-entry-text-color: #FFF;">
    <?php if(!empty($slider_post)): ?>
    <div class="">
        <?php foreach ( $slider_post as $post_id ) :
            $post = get_post( $post_id );
            $get_permalink = get_permalink( $post );
            $get_thumbnail_url = get_the_post_thumbnail_url( $post, 'tenzin-news-magazine-image-large' );
            $avatar = get_avatar($post->post_author);
            $entry_date_format = get_theme_mod('crt_manage_entry_date_format', 'F d, Y');
        ?>
            <div class="hero-post-v5__item">
                <div class="position-relative">
                    <img class="lazy" data-src="<?php echo esc_attr($get_thumbnail_url); ?>" alt="<?php echo esc_html($post->post_title); ?>" />
                    <div class="hero-post-v5__content">
                        <div class="hero-post-v5__content--inner">
                            <?php tenzin_news_magazine_entry_options($post); ?>
                            <h2 class="hero-post-v5__title mb-2"><a href="<?php echo esc_attr($get_permalink); ?>"><?php echo esc_html($post->post_title); ?></a></h2>
                            <div class="excerpt-default">
                                <?php echo tenzin_news_magazine_excerpt_custom(30, $post_id); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>

