<?php
    $slider_post = get_theme_mod('crt_manage_hero_v1_left_post');
    $slider_thumbnail = 'ratio57';
    $slider_nav_style = get_theme_mod('crt_manage_hero_v1_nav_style', 'square');
?>
<div class="col-md-12 mb-md-0 mb-3">
    <?php if(!empty($slider_post)): ?>
    <div class="slider-post__v4 post_slider__js owl-carousel owl-theme <?php echo 'slider-post__nav--' . esc_attr($slider_nav_style); ?>">
        <?php foreach ( $slider_post as $post_id ) {
            $post = get_post( $post_id );
            $get_permalink = get_permalink( $post );
            $get_thumbnail_url = get_the_post_thumbnail_url( $post, 'tenzin-news-magazine-image-medium' );
            $avatar = get_avatar($post->post_author);
            $entry_date_format = get_theme_mod('crt_manage_entry_date_format', 'F d, Y');
            $date = date($entry_date_format, strtotime($post->post_date));
        ?>
            <div class="slider-post__item">
                <figure class="owl-lazy <?php echo esc_attr($slider_thumbnail); ?>" data-src="<?php echo esc_attr($get_thumbnail_url); ?>"></figure>
                <div class="slider-post__content">
                    <?php tenzin_news_magazine_entry_options($post); ?>
                    <h2 class="slider-post__title mb-2"><a href="<?php echo esc_attr($get_permalink); ?>"><?php echo esc_html($post->post_title); ?></a></h2>
                    <div class="excerpt-default">
                        <?php echo tenzin_news_magazine_excerpt_custom(30, $post_id); ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <?php endif; ?>
</div>

