<?php
/**
 * Dimitrova Portfolio functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Tenzin_News_Magazine
 */

if ( ! defined( 'TENZIN_NEWS_MAGAZINE_VERSION' ) ) {
	define( 'TENZIN_NEWS_MAGAZINE_VERSION', wp_get_theme()->get( 'Version' ) );
}
if ( ! defined( 'TENZIN_NEWS_MAGAZINE_NAME' ) ) {
    define( 'TENZIN_NEWS_MAGAZINE_NAME', wp_get_theme()->get( 'Name' ) );
}
if ( ! defined( 'TENZIN_NEWS_MAGAZINE_URL_DEMO' ) ) {
    define( 'TENZIN_NEWS_MAGAZINE_URL_DEMO', wp_get_theme()->get( 'ThemeURI' ) );
}
if ( ! defined( 'TENZIN_NEWS_MAGAZINE_URL_DOCS' ) ) {
    define( 'TENZIN_NEWS_MAGAZINE_URL_DOCS', '#' );
}
if ( ! defined( 'TENZIN_NEWS_MAGAZINE_URL_GET_PREMIUM' ) ) {
    define( 'TENZIN_NEWS_MAGAZINE_URL_GET_PREMIUM', '#' );
}
if ( ! defined( 'TENZIN_NEWS_MAGAZINE_ID_THEMES_PREMIUM' ) ) {
    define( 'TENZIN_NEWS_MAGAZINE_ID_THEMES_PREMIUM', 58 );
}

if ( ! function_exists( 'tenzin_news_magazine_setup' ) ) :
    function tenzin_news_magazine_setup() {

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        add_theme_support( 'title-tag' );

        add_theme_support( 'wp-block-styles' );

        add_theme_support( 'register_block_style' );

        add_theme_support( 'register_block_pattern' );

        add_theme_support( 'post-thumbnails' );

        add_theme_support( 'post-formats', array( 'aside', 'video', 'gallery') );

        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support(
            'custom-logo',
            array(
                'height'      => 250,
                'width'       => 250,
                'flex-width'  => true,
                'flex-height' => true,
            )
        );

        add_theme_support( 'align-wide' );
        add_theme_support( 'responsive-embeds' );

        add_theme_support( 'html5', array(
            'comment-list',
            'comment-form',
            'search-form',
            'gallery',
            'caption',
        ) );

        add_image_size( 'tenzin-news-magazine-image-small', 350, 9999 );
        add_image_size( 'tenzin-news-magazine-image-medium', 600, 9999 );
        add_image_size( 'tenzin-news-magazine-image-large', 1200, 9999 );

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(
            array(
                'primary' => esc_html__( 'Primary', 'tenzin-news-magazine' ),
            )
        );
        register_nav_menus(
            array(
                'footer' => esc_html__( 'Footer', 'tenzin-news-magazine' ),
            )
        );
    }
endif;
add_action( 'after_setup_theme', 'tenzin_news_magazine_setup' );

function tenzin_news_magazine_image_resizes($sizes){
    unset( $sizes['woocommerce_gallery_thumbnail']);
    unset( $sizes['woocommerce_single']);
    unset( $sizes['thumbnail']);
    unset( $sizes['medium']);
    unset( $sizes['medium_large']);
    unset( $sizes['large']);
    unset( $sizes['1536x1536']);
    return $sizes;
}
add_filter('intermediate_image_sizes_advanced', 'tenzin_news_magazine_image_resizes' );

if ( ! function_exists( 'tenzin_news_magazine_after_active' ) ) :
    function tenzin_news_magazine_after_active() {
        $theme_active = get_option('stylesheet');
        if($theme_active == 'tenzin-news-magazine') {
            set_theme_mod('crt_manage_header_nav_style', 'bg-color');
            set_theme_mod('crt_manage_general_homepage_options', 'home-boxed');
        } elseif ($theme_active == 'times-news-magazine-blog') {
            set_theme_mod('crt_manage_header_type', 'v2');
            set_theme_mod('crt_manage_header_social_style', 'border-line-solid');
            set_theme_mod('crt_manage_header_nav_style', 'bg-color');
            set_theme_mod('crt_manage_header_logo_font', 'Playfair Display');
            set_theme_mod('crt_manage_category_layout', 'masonry-4-columns');
            set_theme_mod('crt_manage_category_sidebar', 'no-sidebar');
            set_theme_mod('crt_manage_single_content_font', 'Raleway');
            set_theme_mod('crt_manage_general_nav_font', 'Oswald');
            set_theme_mod('crt_manage_general_post_heading_font', 'Jost');
            set_theme_mod('crt_manage_hero_v1_type', 'v2');
            set_theme_mod('crt_manage_feature_type', 'v2');
        }  elseif ($theme_active == 'fashion-blog-magazine') {
            set_theme_mod('crt_manage_header_nav_style', 'line-dual');
            set_theme_mod('crt_manage_general_homepage_options', 'home-none-boxed');
            set_theme_mod('sections_order', '{"crt_manage_hero_v1_section":10,"crt_manage_feature_section":15,"crt_manage_post_sidebar_section":20,"crt_manage_post_six_section":25,"crt_manage_html_section":30,"crt_manage_post_tax_section":35,"crt_manage_latest_section":40,"crt_manage_content_section":45,"crt_manage_shortcode_section":50,"crt_manage_html_second_section":55}');
            set_theme_mod('crt_manage_header_type', 'v1');
            set_theme_mod('crt_manage_general_nav_font', 'Nanum Gothic');
            set_theme_mod('crt_manage_general_heading_font', 'Roboto');
            set_theme_mod('crt_manage_header_logo_font', 'Italiana');
            set_theme_mod('crt_manage_feature_post', array(190,192,224,226,228));
            set_theme_mod('crt_manage_header_left_show_nav_button', true);
            set_theme_mod('crt_manage_header_left_show_nav_button_m', true);
        }
    }
endif;
add_action('after_switch_theme', 'tenzin_news_magazine_after_active');


if ( ! function_exists( 'tenzin_news_magazine_header_style' ) ) :
    /**
     * Styles the header image and text displayed on the blog.
     *
     * @see tenzin_news_magazine_header_style().
     */
    function tenzin_news_magazine_header_style() {
        $header_text_color = get_header_textcolor();

        /*
         * If no custom options for text are set, let's bail.
         * get_header_textcolor() options: Any hex value, 'blank' to hide text. Default: add_theme_support( 'custom-header' ).
         */
        if ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color ) {
            return;
        }

        // If we get this far, we have custom styles. Let's do this.
        ?>
        <style type="text/css">
            <?php
            // Has the text been hidden?
            if ( ! display_header_text() ) :
                ?>
            .site-title,
            .site-description {
                position: absolute;
                clip: rect(1px, 1px, 1px, 1px);
                color: red !important;
            }
            <?php
            // If the user has set a custom color for the text use that.
        else :
            ?>
            .site-title a,
            .site-description {
                color: #<?php echo esc_attr( $header_text_color ); ?>;
            }
            <?php endif; ?>
        </style>
        <?php
    }
endif;

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function tenzin_news_magazine_content_width() {
    $GLOBALS['content_width'] = apply_filters( 'tenzin_news_magazine_content_width', 640 );
}
add_action( 'after_setup_theme', 'tenzin_news_magazine_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function tenzin_news_magazine_widgets_init() {
    register_sidebar(
        array(
            'name'          => esc_html__( 'Sidebar Front Page', 'tenzin-news-magazine' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'Add widgets here.', 'tenzin-news-magazine' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name'          => esc_html__( 'Sidebar Inner 1', 'tenzin-news-magazine' ),
            'id'            => 'sidebar-2',
            'description'   => esc_html__( 'Add widgets here.', 'tenzin-news-magazine' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name'          => esc_html__( 'Sidebar Inner 2', 'tenzin-news-magazine' ),
            'id'            => 'sidebar-3',
            'description'   => esc_html__( 'Add widgets here.', 'tenzin-news-magazine' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name'          => esc_html__( 'Sidebar Inner 3', 'tenzin-news-magazine' ),
            'id'            => 'sidebar-4',
            'description'   => esc_html__( 'Add widgets here.', 'tenzin-news-magazine' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name'          => esc_html__( 'Sidebar Inner 4', 'tenzin-news-magazine' ),
            'id'            => 'sidebar-5',
            'description'   => esc_html__( 'Add widgets here.', 'tenzin-news-magazine' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name'          => esc_html__( 'Sidebar Inner 5', 'tenzin-news-magazine' ),
            'id'            => 'sidebar-6',
            'description'   => esc_html__( 'Add widgets here.', 'tenzin-news-magazine' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name'          => esc_html__( 'Sidebar Inner 6', 'tenzin-news-magazine' ),
            'id'            => 'sidebar-7',
            'description'   => esc_html__( 'Add widgets here.', 'tenzin-news-magazine' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name'          => esc_html__( 'Sidebar E-Commerce', 'tenzin-news-magazine' ),
            'id'            => 'sidebar-e-commerce',
            'description'   => esc_html__( 'Add widgets here.', 'tenzin-news-magazine' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        )
    );

}
add_action( 'widgets_init', 'tenzin_news_magazine_widgets_init' );


/**
 * Enqueue scripts and styles.
 */
function tenzin_news_magazine_scripts() {
    wp_enqueue_style( 'tenzin-news-magazine-style', get_template_directory_uri() . '/style.css', array(), TENZIN_NEWS_MAGAZINE_VERSION );
    // Main style.
    wp_enqueue_style( 'tenzin-news-magazine-main-style', get_template_directory_uri() . '/assets/build/css/main.min.css', array(), TENZIN_NEWS_MAGAZINE_VERSION );

    // Main script.
    wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array(), TENZIN_NEWS_MAGAZINE_VERSION, true );
    wp_enqueue_script( 'modernizr', get_template_directory_uri() . '/assets/js/modernizr-3.11.2.min.js', array(), TENZIN_NEWS_MAGAZINE_VERSION, true );
    wp_enqueue_script( 'imagesloaded', '', array( ));
    wp_enqueue_script( 'jquery-masonry', '', array( 'jquery' ) );
    wp_enqueue_script( 'sticky', get_template_directory_uri() . '/assets/js/theia-sticky-sidebar.min.js', array(), TENZIN_NEWS_MAGAZINE_VERSION, true );
    wp_enqueue_script( 'resize', get_template_directory_uri() . '/assets/js/resize-sensor.min.js', array(), TENZIN_NEWS_MAGAZINE_VERSION, true );
    wp_enqueue_script( 'jquery-lazy', get_template_directory_uri() . '/assets/js/jquery.lazy.min.js', array(), TENZIN_NEWS_MAGAZINE_VERSION, true );
    wp_enqueue_script( 'tenzin-news-magazine-main-script', get_template_directory_uri() . '/assets/js/main.js', array( 'jquery' ), TENZIN_NEWS_MAGAZINE_VERSION, true );

    wp_add_inline_script( 'tenzin-news-magazine-main-script', 'const TENZIN_SCRIPT = ' . tenzin_news_magazine_script_inline(), 'before' );

    // Register script.
    for($layout = 1; $layout <= 12; $layout++):
        wp_register_style( 'tenzin-news-magazine-layout-' . $layout, get_template_directory_uri() . '/assets/css/layout/layout-'.$layout.'.css', array(), TENZIN_NEWS_MAGAZINE_VERSION );
    endfor;

    // Register script tax.
    for($tax = 1; $tax <= 3; $tax++):
        wp_register_style( 'tenzin-news-magazine-tax-' . $tax, get_template_directory_uri() . '/assets/css/layout/tax-' . $tax . '.css', array(), TENZIN_NEWS_MAGAZINE_VERSION );
    endfor;

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'tenzin_news_magazine_scripts' );



function tenzin_news_magazine_dynamic_front_end_css() {
    $heading_style = get_theme_mod('crt_manage_heading_style', 'center');
    $heading_line_color = get_theme_mod('crt_manage_heading_line_color', '#000');
    $heading_line_size = get_theme_mod('crt_manage_heading_line_size', '1px');
    $heading_font = get_theme_mod('crt_manage_general_heading_font', 'Oswald');
    $heading_size = get_theme_mod('crt_manage_general_heading_size', '36px');
    $heading_transform = get_theme_mod('crt_manage_general_heading_transform', 'uppercase');
    $heading_letter_spacing = get_theme_mod('crt_manage_general_heading_letter_spacing', '0px');
    $heading_sub_font = get_theme_mod('crt_manage_general_heading_sub_font', 'Oswald');
    $heading_sub_size = get_theme_mod('crt_manage_general_heading_sub_size', '12px');
    $heading_sub_transform = get_theme_mod('crt_manage_general_heading_sub_transform', 'uppercase');
    $heading_sub_letter_spacing = get_theme_mod('crt_manage_general_heading_sub_letter_spacing', '0px');
    $header_nav_transform = get_theme_mod('crt_manage_general_nav_transform', 'uppercase');
    $header_nav_transform = get_theme_mod('crt_manage_general_nav_transform', 'uppercase');

    $heading_size_h1 = get_theme_mod('crt_manage_general_heading_size_1', '2.5rem');
    $heading_size_h2 = get_theme_mod('crt_manage_general_heading_size_2', '2rem');
    $heading_size_h3 = get_theme_mod('crt_manage_general_heading_size_3', '1.75rem');
    $heading_size_h4 = get_theme_mod('crt_manage_general_heading_size_4', '1.5rem');
    $heading_size_h5 = get_theme_mod('crt_manage_general_heading_size_5', '1.25rem');
    $heading_size_h6 = get_theme_mod('crt_manage_general_heading_size_6', '1rem');
    $entry_font = get_theme_mod('crt_manage_entry_font', 'Oswald');
    $entry_transform = get_theme_mod('crt_manage_entry_text_transform', 'uppercase');
    $entry_color = get_theme_mod('crt_manage_entry_text_color', '#000');
    $entry_size = get_theme_mod('crt_manage_entry_text_size', '12px');
    $header_nav_color = get_theme_mod('crt_manage_general_nav_color', '#000');
    $header_nav_height = get_theme_mod('crt_manage_general_nav_size', '38px');
    $header_nav_font_size = get_theme_mod('crt_manage_general_nav_font_size', '16px');
    $header_nav_font = get_theme_mod('crt_manage_general_nav_font', 'Oswald');
    $header_nav_bg = get_theme_mod('crt_manage_general_nav_bg_color', '#000');
    $header_nav_line_color = get_theme_mod('crt_manage_general_nav_line_color', '#000');
    $heading_post_font = get_theme_mod('crt_manage_general_post_heading_font', 'Oswald');
    $logo_font = get_theme_mod('crt_manage_header_logo_font', 'Oswald');

    //Body

    $home_border_color = get_theme_mod('crt_manage_general_homepage_border_color_page', '#000');
    $home_border_size = get_theme_mod('crt_manage_general_homepage_border_size_page', '10px');

    $custom_css = '';
    $custom_css .= ' :root {
                    --border-border-size: '.esc_attr($home_border_size).';
                    --border-border-color: '.esc_attr($home_border_color).';
                   --heading-style: '. esc_attr( $heading_style ) .';
                   --heading-line-color: '. esc_attr( $heading_line_color ) .';
                   --heading-line-size: '. esc_attr( $heading_line_size ) .';
                   --heading-font-family: "'. esc_attr( $heading_font ) .'", serif;
                   --heading-font-size: '. esc_attr( $heading_size ) .';
                   --heading-font-transform: '. esc_attr( $heading_transform ) .';
                   --heading-font-letter-spacing: '. esc_attr( $heading_letter_spacing ) .';
                   --heading-sub-font-family: "'. esc_attr( $heading_sub_font ) .'", serif;
                   --heading-sub-font-size: '. esc_attr( $heading_sub_size ) .';
                   --heading-sub-font-transform: '. esc_attr( $heading_sub_transform ) .';
                   --heading-sub-font-letter-spacing: '. esc_attr( $heading_sub_letter_spacing ) .';
                    --primary-font-post-heading: "'. esc_attr( $heading_post_font ) .'", serif;
                    --header-nav-transform: '. esc_attr( $header_nav_transform ) .';
                    --var-heading-h1: '. esc_attr( $heading_size_h1 ) .';
                    --var-heading-h2: '. esc_attr( $heading_size_h2 ) .';
                    --var-heading-h3: '. esc_attr( $heading_size_h3 ) .';
                    --var-heading-h4: '. esc_attr( $heading_size_h4 ) .';
                    --var-heading-h5: '. esc_attr( $heading_size_h5 ) .';
                    --var-heading-h6: '. esc_attr( $heading_size_h6 ) .';
                    --primary-font-entry: "'. esc_attr( $entry_font ) .'", serif;
                    --primary-entry-text-transform: '. esc_attr( $entry_transform ) .';
                    --primary-entry-text-color: '. esc_attr( $entry_color ) .';
                    --primary-entry-text-size: '. esc_attr( $entry_size ) .';
                    --header-nav-font-size: '. esc_attr( $header_nav_font_size ) .';
                    --header-nav-height: '. esc_attr( $header_nav_height ) .';
                    --header-nav-color: '. esc_attr( $header_nav_color ) .';
                    --header-nav-font: "'. esc_attr( $header_nav_font ) .'", serif;
                    --font-logo: "'. esc_attr( $logo_font ) .'", serif;
                    --header-nav-bg: '. esc_attr( $header_nav_bg ) .';
                    --header-nav-line-color: '. esc_attr( $header_nav_line_color ) .';
                }';
    wp_register_style( 'tenzin-news-magazine-style-inline', false );
    wp_enqueue_style( 'tenzin-news-magazine-style-inline' );
    wp_add_inline_style( 'tenzin-news-magazine-style-inline', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'tenzin_news_magazine_dynamic_front_end_css' );

/**
 * Define script const
/**/
function tenzin_news_magazine_script_inline() {
    $hero_type = get_theme_mod('crt_manage_hero_v1_type', 'v1');
    $slider_show = 1;
    $slider_show_table = 1;
    $slider_margin = 0;
    if($hero_type == 'v4') {
        $slider_margin = 10;
        $slider_show = 3;
        $slider_show_table = 2;
    }
    $script_inline = json_encode( array(
        'ajaxUrl' => admin_url( 'admin-ajax.php' ),
        'HERO_SLIDER_SHOW' => $slider_show,
        'HERO_SLIDER_MARGIN' => $slider_margin,
        'HERO_SLIDER_SHOW_TABLE' => $slider_show_table,
        'SITE' => get_template_directory_uri(),
    ));
    return $script_inline;
}

/**
 * Include wptt webfont loader.
 */
require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Dynamic CSS
 */
require get_template_directory() . '/inc/dynamic-css.php';

/**
 * Breadcrumb
 */
require get_template_directory() . '/inc/class-breadcrumb-trail.php';

/**
 * Recommended Plugins
 */
require get_template_directory() . '/inc/tgmpa/recommended-plugins.php';


/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
    require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Post View Count
/**/
function tenzin_news_magazine_set_post_view_count($postID) {
    $countKey = 'post_view_count';
    $count = get_post_meta($postID, $countKey, true);
    if($count == ''){
        $count = 0;
        delete_post_meta($postID, $countKey);
        add_post_meta($postID, $countKey, '1');
    } else{
        $count++;
        update_post_meta($postID, $countKey, $count);
    }
}

/**
 * Woocommerce.
 */
if ( class_exists( 'WooCommerce' ) ) {
    require get_template_directory() . '/inc/woocommerce.php';
}

if ( ! function_exists( 'tenzin_news_magazine_is_woocommerce' ) ) {
    function tenzin_news_magazine_is_woocommerce() {
        if(class_exists( 'WooCommerce' )) {
            return true;
        }
        return false;
    }
}
/**
 * CRT Manage is active.
 */
if ( ! function_exists( 'crt_manage_plugins_is_active' ) ) {
    function crt_manage_plugins_is_active() {
        if(class_exists( 'CRT_Manage_Base' )) {
            return true;
        }
        return false;
    }
}

/**
 * Custom Heading Archive.
 */
add_filter('get_the_archive_title', function ($title) {
    $title  = __( 'Archives','tenzin-news-magazine' );

    if ( is_category() ) {
        $title  = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title  = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title  = get_the_author();
    } elseif ( is_year() ) {
        /* translators: See https://www.php.net/manual/datetime.format.php */
        $title  = get_the_date( _x( 'Y', 'yearly archives date format','tenzin-news-magazine' ) );
    } elseif ( is_month() ) {
        /* translators: See https://www.php.net/manual/datetime.format.php */
        $title  = get_the_date( _x( 'F Y', 'monthly archives date format','tenzin-news-magazine' ) );
    } elseif ( is_day() ) {
        /* translators: See https://www.php.net/manual/datetime.format.php */
        $title  = get_the_date( _x( 'F j, Y', 'daily archives date format','tenzin-news-magazine' ) );
    } elseif ( is_tax( 'post_format' ) ) {
        if ( is_tax( 'post_format', 'post-format-aside' ) ) {
            $title = _x( 'Asides', 'post format archive title','tenzin-news-magazine' );
        } elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) {
            $title = _x( 'Galleries', 'post format archive title','tenzin-news-magazine' );
        } elseif ( is_tax( 'post_format', 'post-format-image' ) ) {
            $title = _x( 'Images', 'post format archive title','tenzin-news-magazine' );
        } elseif ( is_tax( 'post_format', 'post-format-video' ) ) {
            $title = _x( 'Videos', 'post format archive title','tenzin-news-magazine' );
        } elseif ( is_tax( 'post_format', 'post-format-quote' ) ) {
            $title = _x( 'Quotes', 'post format archive title','tenzin-news-magazine' );
        } elseif ( is_tax( 'post_format', 'post-format-link' ) ) {
            $title = _x( 'Links', 'post format archive title','tenzin-news-magazine' );
        } elseif ( is_tax( 'post_format', 'post-format-status' ) ) {
            $title = _x( 'Statuses', 'post format archive title','tenzin-news-magazine' );
        } elseif ( is_tax( 'post_format', 'post-format-audio' ) ) {
            $title = _x( 'Audio', 'post format archive title','tenzin-news-magazine' );
        } elseif ( is_tax( 'post_format', 'post-format-chat' ) ) {
            $title = _x( 'Chats', 'post format archive title','tenzin-news-magazine' );
        }
    } elseif ( is_post_type_archive() ) {
        $title  = post_type_archive_title( '', false );
    } elseif ( is_tax() ) {
        $queried_object = get_queried_object();
        if ( $queried_object ) {
            $tax    = get_taxonomy( $queried_object->taxonomy );
            $title  = single_term_title( '', false );
        }
    } elseif (is_cart()) {
        $title = _x( 'Cart', 'post format archive title','tenzin-news-magazine' );
    } elseif (is_checkout()) {
        $title = _x( 'Checkout', 'post format archive title','tenzin-news-magazine' );
    }  elseif (is_search()) {
        $value = get_search_query();
        $title = sprintf( esc_html__( 'Search: %s','tenzin-news-magazine' ), $value);
    }
    return $title;
});
