<?php
/**
 * Template Name: Magazine
 *
 * @package Tenocation
 */
get_header();
?>

<?php do_action('tenocation_before_body_content'); ?>

<?php if (is_active_sidebar('tenocation-magazine-slider-sidebar') || is_active_sidebar('tenocation-magazine-beside-slider-sidebar')) : ?>
	<div class="magazine-page-top-area clear">
		<div class="slider-area">
			<?php
			if (is_active_sidebar('tenocation-magazine-slider-sidebar')) {
				dynamic_sidebar('tenocation-magazine-slider-sidebar');
			}
			?>
		</div>

		<div class="beside-slider-area">
			<?php
			if (is_active_sidebar('tenocation-magazine-beside-slider-sidebar')) {
				dynamic_sidebar('tenocation-magazine-beside-slider-sidebar');
			}
			?>
		</div>
	</div>
<?php endif; ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

		<div class="magazine-page-content-top-sidebar clear">
			<?php
			if (is_active_sidebar('tenocation-magazine-top-content-sidebar')) {
				dynamic_sidebar('tenocation-magazine-top-content-sidebar');
			}
			?>
		</div>

		<?php if (is_active_sidebar('tenocation-magazine-middle-left-sidebar') || is_active_sidebar('tenocation-magazine-middle-right-sidebar')) : ?>
			<div class="magazine-page-half clear">
				<?php
				if (is_active_sidebar('tenocation-magazine-middle-left-sidebar')) {
					dynamic_sidebar('tenocation-magazine-middle-left-sidebar');
				}
				?>
			</div>

			<div class="magazine-page-half magazine-page-half-last">
				<?php
				if (is_active_sidebar('tenocation-magazine-middle-right-sidebar')) {
					dynamic_sidebar('tenocation-magazine-middle-right-sidebar');
				}
				?>
			</div>
		<?php endif; ?>

		<div class="magazine-page-content-bottom-sidebar clear">
			<?php
			if (is_active_sidebar('tenocation-magazine-bottom-content-sidebar')) {
				dynamic_sidebar('tenocation-magazine-bottom-content-sidebar');
			}
			?>
		</div>

	</main><!-- #main -->
</div><!-- #primary -->

<?php tenocation_sidebar_select(); ?>

<?php do_action('tenocation_after_body_content'); ?>

<?php get_footer(); ?>
