<?php

/**
 * Contains all the widgets parts included in the theme
 *
 * @package Tenocation
 */
class tenocation_random_posts_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
				'tenocation_random_posts_widget', esc_html__('tenocation: Random Posts Widget', 'tenocation'), // Name of the widget
				array('description' => esc_html__('Displays the random posts from your site.', 'tenocation'), 'classname' => 'widget-entry-meta tenocation-random-posts-widget clear') // Arguments of the widget, here it is provided with the description
		);
	}

	function form($instance) {
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		$title = !empty($instance['title']) ? $instance['title'] : '';
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of random posts to display:', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo absint($number); ?>" size="3">
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = array();
		$instance['number'] = !empty($new_instance['number']) ? absint($new_instance['number']) : 5;
		$instance['title'] = sanitize_text_field($new_instance['title']);

		return $instance;
	}

	function widget($args, $instance) {
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		$title = isset($instance['title']) ? $instance['title'] : '';

		echo wp_kses_post($args['before_widget']);
		?>
		<div class="random-posts-widget" id="random-posts">
			<?php
			global $post;
			$random_posts = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'orderby' => 'rand',
				'no_found_rows' => true
			));
			?>

			<?php
			if (!empty($title)) {
				echo wp_kses_post($args['before_title']) . esc_html($title) . wp_kses_post($args['after_title']);
			}
			?>

			<?php
			while ($random_posts->have_posts()) :
				$random_posts->the_post();
				?>
				<div class="single-article-content clear">
					<?php if (has_post_thumbnail()) { ?>
						<figure class="featured-image">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('tenocation-featured-small-thumbnail'); ?></a>
						</figure>
					<?php } ?>
					<h3 class="entry-title">
						<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
					</h3>
					<div class="entry-meta">
						<?php tenocation_widget_posts_posted_on(); ?>
					</div>
				</div>
				<?php
			endwhile;
			// Reset Post Data
			wp_reset_postdata();
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

class tenocation_Tabbed_Widget extends WP_Widget {

	/**
	 * Register widget in WordPress
	 */
	function __construct() {
		parent::__construct(
				'tenocation_Tabbed_Widget', esc_html__('tenocation: Tabbed Widget', 'tenocation'), // Name of the widget
				array('description' => esc_html__('Displays the popular posts, recent posts and the recent comments in the tabs.', 'tenocation'), 'classname' => 'widget-entry-meta tenocation-tabbed-widget clear') // Arguments of the widget, here it is provided with the description
		);
	}

	function form($instance) {
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of popular posts, recent posts and comments to display:', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo absint($number); ?>" size="3">
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = array();
		$instance['number'] = !empty($new_instance['number']) ? absint($new_instance['number']) : 5;

		return $instance;
	}

	function widget($args, $instance) {
		// enqueue the required js files
		if (is_active_widget(false, false, $this->id_base) || is_customize_preview()) {
			wp_enqueue_script('jquery-ui-tabs');
		}

		$number = !empty($instance['number']) ? $instance['number'] : 5;
		echo wp_kses_post($args['before_widget']);
		?>

		<div class="tab-content tenocation-tab-content">

			<ul class="tenocation-tabs" role="tablist">
				<li role="presentation" class="popular"><a href="#popular"><i class="fa fa-star"></i><?php esc_html_e('Popular', 'tenocation'); ?></a></li>
				<li role="presentation" class="recent"><a href="#recent"><i class="fa fa-history"></i><?php esc_html_e('Recent', 'tenocation'); ?></a></li>
				<li role="presentation" class="comment"><a href="#user-comments"><i class="fa fa-comment"></i><?php esc_html_e('Comment', 'tenocation'); ?></a></li>
			</ul>

			<!-- Popular Tab -->
			<div role="tabpanel" class="tabs-panel popular-tab" id="popular">
				<?php
				global $post;
				$get_popular_posts = new WP_Query(array(
					'posts_per_page' => $number,
					'post_type' => 'post',
					'ignore_sticky_posts' => true,
					'orderby' => 'comment_count',
					'no_found_rows' => true
				));
				?>
				<?php while ($get_popular_posts->have_posts()) : $get_popular_posts->the_post(); ?>
					<div class="single-article-content clear">
						<?php if (has_post_thumbnail()) { ?>
							<figure class="featured-image">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('tenocation-featured-small-thumbnail'); ?></a>
							</figure>
						<?php } ?>
						<h3 class="entry-title">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
						</h3>
						<div class="entry-meta">
							<?php tenocation_widget_posts_posted_on(); ?>
						</div>
					</div>
					<?php
				endwhile;
				// Reset Post Data
				wp_reset_postdata();
				?>
			</div>

			<!-- Recent Tab -->
			<div role="tabpanel" class="tabs-panel recent-tab" id="recent">
				<?php
				global $post;
				$get_recent_posts = new WP_Query(array(
					'posts_per_page' => $number,
					'post_type' => 'post',
					'ignore_sticky_posts' => true,
					'no_found_rows' => true
				));
				?>
				<?php
				while ($get_recent_posts->have_posts()) : $get_recent_posts->the_post();
					?>
					<div class="single-article-content clear">
						<?php if (has_post_thumbnail()) { ?>
							<figure class="featured-image">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('tenocation-featured-small-thumbnail'); ?></a>
							</figure>
						<?php } ?>
						<h3 class="entry-title">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
						</h3>
						<div class="entry-meta">
							<?php tenocation_widget_posts_posted_on(); ?>
						</div>
					</div>
					<?php
				endwhile;
				// Reset Post Data
				wp_reset_postdata();
				?>
			</div>

			<!-- Comment Tab -->
			<div role="tabpanel" class="tabs-panel comment-tab" id="user-comments">
				<?php
				$comments_query = new WP_Comment_Query();
				$comments = $comments_query->query(array('number' => $number, 'status' => 'approve'));
				$commented = '';
				$commented .= '<ul class="comments-tab">';
				if ($comments) : foreach ($comments as $comment) :
						$commented .= '<li class="comments-tab-widget clear"><a class="author" href="' . esc_url(get_permalink($comment->comment_post_ID)) . '#comment-' . $comment->comment_ID . '">';
						$commented .= get_avatar($comment->comment_author_email, '60');
						$commented .= get_comment_author($comment->comment_ID) . '</a>' . ' ' . esc_html__('says:', 'tenocation');
						$commented .= '<p class="commented-post">' . strip_tags(substr(apply_filters('get_comment_text', $comment->comment_content), 0, '50')) . '&hellip;</p></li>';
					endforeach;
				else :
					$commented .= '<p class="no-comments-commented-post">' . esc_html__('No Comments', 'tenocation') . '</p>';
				endif;
				$commented .= '</ul>';
				echo wp_kses_post($commented);
				?>
			</div>

		</div>

		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

class tenocation_Posts_Slider_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
				'tenocation_Posts_Slider_Widget', esc_html__('tenocation: Posts Slider Widget', 'tenocation'), // Name of the widget
				array('description' => esc_html__('Displays the latest posts or posts from certain category chosen to be used as the slider.', 'tenocation'), 'classname' => 'widget-entry-meta tenocation-posts-slider-widget clear') // Arguments of the widget, here it is provided with the description
		);
	}

	function form($instance) {
		$number = !empty($instance['number']) ? $instance['number'] : 4;
		$type = !empty($instance['type']) ? $instance['type'] : 'latest';
		$category = !empty($instance['category']) ? $instance['category'] : '';
		?>
		<p>
			<label>
				<input type="radio" <?php checked($type, 'latest') ?> id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" value="latest"><?php esc_html_e('Show latest posts.', 'tenocation'); ?>
			</label>
			<br/>
			<label>
				<input type="radio" <?php checked($type, 'category') ?> id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" value="category"><?php esc_html_e('Show posts from a certain category.', 'tenocation'); ?>
			</label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('category')); ?>"><?php esc_html_e('Select the category:', 'tenocation'); ?>
				<?php
				wp_dropdown_categories(array(
					'show_option_none' => ' ',
					'name' => $this->get_field_name('category'),
					'selected' => $category
				));
				?>
			</label>
		</p>

		<p>
			<label for="<?php echo  esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts to display:', 'tenocation'); ?></label>
			<input id="<?php echo  esc_attr($this->get_field_id('number')); ?>" name="<?php echo  esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo  esc_attr(absint($number)); ?>" size="3">
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = array();
		$instance['number'] = !empty($new_instance['number']) ? absint($new_instance['number']) : 4;
		$instance['type'] = sanitize_key($new_instance['type']);
		$instance['category'] = absint($new_instance['category']);

		return $instance;
	}

	function widget($args, $instance) {
		// enqueue the required js files
		if (is_active_widget(false, false, $this->id_base) || is_customize_preview()) {
			wp_enqueue_script('jquery-bxslider');
		}

		$number = !empty($instance['number']) ? $instance['number'] : 4;
		$type = isset($instance['type']) ? $instance['type'] : 'latest';
		$category = isset($instance['category']) ? $instance['category'] : '';

		echo wp_kses_post($args['before_widget']);
		?>
		<?php
		global $post;
		if ($type == 'latest') {
			$category_posts_slider = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'no_found_rows' => true
			));
		} else {
			$category_posts_slider = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'category__in' => $category,
				'no_found_rows' => true
			));
		}
		?>

		<div class="tenocation-category-slider">
			<?php
			while ($category_posts_slider->have_posts()) :
				$category_posts_slider->the_post();
				?>
				<?php if (has_post_thumbnail()) { ?>
					<div class="single-article-content">
						<div class="category-links">
							<?php tenocation_colored_category(); ?>
						</div><!-- .entry-meta -->

						<figure class="featured-image">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('tenocation-featured-large-thumbnail'); ?></a>
						</figure>

						<div class="category-title-meta-wrapper">
							<h3 class="entry-title">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
							</h3>
							<div class="entry-meta">
								<?php tenocation_widget_posts_posted_on(); ?>
							</div>
						</div>
					</div>
				<?php } ?>
				<?php
			endwhile;
			// Reset Post Data
			wp_reset_postdata();
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

class tenocation_Posts_Grid_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
				'tenocation_Posts_Grid_Widget', esc_html__('tenocation: Posts Grid Widget', 'tenocation'), // Name of the widget
				array('description' => esc_html__('Displays the latest posts or posts from certain category chosen to be used in beside the slider area.', 'tenocation'), 'classname' => 'widget-entry-meta tenocation-posts-grid-widget clear') // Arguments of the widget, here it is provided with the description
		);
	}

	function form($instance) {
		$number = !empty($instance['number']) ? $instance['number'] : 4;
		$type = !empty($instance['type']) ? $instance['type'] : 'latest';
		$category = !empty($instance['category']) ? $instance['category'] : '';
		?>
		<p>
			<label>
				<input type="radio" <?php checked($type, 'latest') ?> id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" value="latest"><?php esc_html_e('Show latest posts.', 'tenocation'); ?>
			</label>
			<br/>
			<label>
				<input type="radio" <?php checked($type, 'category') ?> id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" value="category"><?php esc_html_e('Show posts from a certain category.', 'tenocation'); ?>
			</label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('category')); ?>"><?php esc_html_e('Select the category:', 'tenocation'); ?>
				<?php
				wp_dropdown_categories(array(
					'show_option_none' => ' ',
					'name' => $this->get_field_name('category'),
					'selected' => $category
				));
				?>
			</label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts to display:', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr(absint($number)); ?>" size="3">
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = array();
		$instance['number'] = !empty($new_instance['number']) ? absint($new_instance['number']) : 4;
		$instance['type'] = sanitize_key($new_instance['type']);
		$instance['category'] = absint($new_instance['category']);

		return $instance;
	}

	function widget($args, $instance) {
		$number = !empty($instance['number']) ? $instance['number'] : 4;
		$type = isset($instance['type']) ? $instance['type'] : 'latest';
		$category = isset($instance['category']) ? $instance['category'] : '';

		echo wp_kses_post($args['before_widget']);
		?>
		<?php
		global $post;
		if ($type == 'latest') {
			$category_posts_grid = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'no_found_rows' => true
			));
		} else {
			$category_posts_grid = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'category__in' => $category,
				'no_found_rows' => true
			));
		}
		?>

		<div class="tenocation-posts-grid">
			<?php
			while ($category_posts_grid->have_posts()) :
				$category_posts_grid->the_post();
				?>
				<?php if (has_post_thumbnail()) { ?>
					<div class="single-article-content">
						<div class="category-links">
							<?php tenocation_colored_category(); ?>
						</div><!-- .entry-meta -->

						<figure class="featured-image">
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('tenocation-featured-medium-thumbnail'); ?></a>
						</figure>

						<div class="category-title-meta-wrapper">
							<h3 class="entry-title">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
							</h3>
							<div class="entry-meta">
								<?php tenocation_widget_posts_posted_on(); ?>
							</div>
						</div>
					</div>
				<?php } ?>
				<?php
			endwhile;
			// Reset Post Data
			wp_reset_postdata();
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

class tenocation_Posts_One_Column_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
				'tenocation_Posts_One_Column_Widget', esc_html__('tenocation: Posts One Column Widget', 'tenocation'), // Name of the widget
				array('description' => esc_html__('Displays the latest posts or posts from certain category chosen to display the posts in single column.', 'tenocation'), 'classname' => 'widget-entry-meta tenocation-one-column-widget clear') // Arguments of the widget, here it is provided with the description
		);
	}

	function form($instance) {
		$title = !empty($instance['title']) ? $instance['title'] : '';
		$text = !empty($instance['text']) ? $instance['text'] : '';
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		$type = !empty($instance['type']) ? $instance['type'] : 'latest';
		$category = !empty($instance['category']) ? $instance['category'] : '';
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e('Description', 'tenocation'); ?></label>
			<textarea class="widefat" rows="5" cols="20" id="<?php echo  esc_attr($this->get_field_id('text')); ?>" name="<?php echo  esc_attr($this->get_field_name('text')); ?>"><?php echo esc_attr($text); ?></textarea>
		</p>

		<p>
			<label>
				<input type="radio" <?php checked($type, 'latest') ?> id="<?php echo  esc_attr($this->get_field_id('type')); ?>" name="<?php echo  esc_attr($this->get_field_name('type')); ?>" value="latest"><?php esc_html_e('Show latest posts.', 'tenocation'); ?>
			</label>
			<br/>
			<label>
				<input type="radio" <?php checked($type, 'category') ?> id="<?php echo  esc_attr($this->get_field_id('type')); ?>" name="<?php echo  esc_attr($this->get_field_name('type')); ?>" value="category"><?php esc_html_e('Show posts from a certain category.', 'tenocation'); ?>
			</label>
		</p>

		<p>
			<label for="<?php echo  esc_attr($this->get_field_id('category')); ?>"><?php esc_html_e('Select the category:', 'tenocation'); ?>
				<?php
				wp_dropdown_categories(array(
					'show_option_none' => ' ',
					'name' => $this->get_field_name('category'),
					'selected' => $category
				));
				?>
			</label>
		</p>

		<p>
			<label for="<?php echo  esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts to display:', 'tenocation'); ?></label>
			<input id="<?php echo  esc_attr($this->get_field_id('number')); ?>" name="<?php echo  esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo  esc_attr(absint($number)); ?>" size="3">
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['text'] = sanitize_text_field($new_instance['text']);
		$instance['number'] = !empty($new_instance['number']) ? absint($new_instance['number']) : 5;
		$instance['type'] = sanitize_key($new_instance['type']);
		$instance['category'] = absint($new_instance['category']);

		return $instance;
	}

	function widget($args, $instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$text = isset($instance['text']) ? $instance['text'] : '';
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		$type = isset($instance['type']) ? $instance['type'] : 'latest';
		$category = isset($instance['category']) ? $instance['category'] : '';

		echo wp_kses_post($args['before_widget']);
		?>
		<?php
		global $post;
		if ($type == 'latest') {
			$category_column_one = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'no_found_rows' => true
			));
		} else {
			$category_column_one = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'category__in' => $category,
				'no_found_rows' => true
			));
		}
		?>

		<?php
		if ($type != 'latest') {
			$border_color = 'style="border-bottom-color:' . tenocation_category_color($category) . ';"';
			$title_color = 'style="background-color:' . tenocation_category_color($category) . ';"';
		} else {
			$border_color = '';
			$title_color = '';
		}

		if (!empty($title)) {
			echo '<h3 class="widget-title" ' . wp_kses_post($border_color) . '><span ' . wp_kses_post($title_color) . '>' . esc_html($title) . '</span></h3>';
		}
		if (!empty($text)) {
			?>
			<p><?php echo esc_html($text); ?></p>
		<?php } ?>

		<div class="tenocation-one-column-posts">
			<?php
			$i = 1;
			while ($category_column_one->have_posts()) :
				$category_column_one->the_post();
				if ($i == 1) {
					echo '<div class="first-post">';
					$featured_image_size = 'tenocation-featured-medium-thumbnail';
				} elseif ($i == 2) {
					echo '<div class="following-post">';
					$featured_image_size = 'tenocation-featured-small-thumbnail';
				}
				// adding the class name upon thumbnail availablility
				if (has_post_thumbnail()) {
					$class = 'has-featured-image';
				} else {
					$class = 'no-featured-image';
				}
				?>
				<div class="single-article-content clear">
					<div class="posts-column-wrapper <?php echo esc_attr($class); ?>">
						<?php if ($i == 1) { ?>
							<div class="category-links">
								<?php tenocation_colored_category(); ?>
							</div><!-- .entry-meta -->
						<?php } ?>

						<?php if (has_post_thumbnail()) { ?>
							<figure class="featured-image">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail($featured_image_size); ?></a>
							</figure>
						<?php } ?>

						<div class="category-title-meta-wrapper">
							<h3 class="entry-title">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
							</h3>
							<div class="entry-meta">
								<?php tenocation_widget_posts_posted_on(); ?>
							</div>
						</div>
					</div>

					<?php if ($i == 1) { ?>
						<div class="entry-content">
							<?php the_excerpt(); ?>
						</div>
					<?php } ?>

				</div>
				<?php
				if ($i == 1) {
					echo '</div>';
				}
				$i++;
			endwhile;
			if ($i > 2) {
				echo '</div>';
			}
			// Reset Post Data
			wp_reset_postdata();
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

class tenocation_Posts_Two_Column_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
				'tenocation_Posts_Two_Column_Widget', esc_html__('tenocation: Posts Two Column Widget', 'tenocation'), // Name of the widget
				array('description' => esc_html__('Displays the latest posts or posts from certain category chosen to display the posts in double column.', 'tenocation'), 'classname' => 'widget-entry-meta tenocation-two-column-widget clear') // Arguments of the widget, here it is provided with the description
		);
	}

	function form($instance) {
		$title = !empty($instance['title']) ? $instance['title'] : '';
		$text = !empty($instance['text']) ? $instance['text'] : '';
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		$type = !empty($instance['type']) ? $instance['type'] : 'latest';
		$category = !empty($instance['category']) ? $instance['category'] : '';
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e('Description', 'tenocation'); ?></label>
			<textarea class="widefat" rows="5" cols="20" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>"><?php echo esc_attr($text); ?></textarea>
		</p>

		<p>
			<label>
				<input type="radio" <?php checked($type, 'latest') ?> id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" value="latest"><?php esc_html_e('Show latest posts.', 'tenocation'); ?>
			</label>
			<br/>
			<label>
				<input type="radio" <?php checked($type, 'category') ?> id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" value="category"><?php esc_html_e('Show posts from a certain category.', 'tenocation'); ?>
			</label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('category')); ?>"><?php esc_html_e('Select the category:', 'tenocation'); ?>
				<?php
				wp_dropdown_categories(array(
					'show_option_none' => ' ',
					'name' => $this->get_field_name('category'),
					'selected' => $category
				));
				?>
			</label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts to display:', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr(absint($number)); ?>" size="3">
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['text'] = sanitize_text_field($new_instance['text']);
		$instance['number'] = !empty($new_instance['number']) ? absint($new_instance['number']) : 5;
		$instance['type'] = sanitize_key($new_instance['type']);
		$instance['category'] = absint($new_instance['category']);

		return $instance;
	}

	function widget($args, $instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$text = isset($instance['text']) ? $instance['text'] : '';
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		$type = isset($instance['type']) ? $instance['type'] : 'latest';
		$category = isset($instance['category']) ? $instance['category'] : '';

		echo wp_kses_post($args['before_widget']);
		?>
		<?php
		global $post;
		if ($type == 'latest') {
			$category_column_two = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'no_found_rows' => true
			));
		} else {
			$category_column_two = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'category__in' => $category,
				'no_found_rows' => true
			));
		}
		?>

		<?php
		if ($type != 'latest') {
			$border_color = 'style="border-bottom-color:' . tenocation_category_color($category) . ';"';
			$title_color = 'style="background-color:' . tenocation_category_color($category) . ';"';
		} else {
			$border_color = '';
			$title_color = '';
		}

		if (!empty($title)) {
			echo '<h3 class="widget-title" ' . wp_kses_post($border_color) . '><span ' . wp_kses_post($title_color) . '>' . esc_html($title) . '</span></h3>';
		}
		if (!empty($text)) {
			?>
			<p><?php echo esc_html($text); ?></p>
		<?php } ?>

		<div class="tenocation-two-column-posts">
			<?php
			$i = 1;
			while ($category_column_two->have_posts()) :
				$category_column_two->the_post();
				if ($i == 1) {
					echo '<div class="first-post">';
					$featured_image_size = 'tenocation-featured-medium-thumbnail';
				} elseif ($i == 2) {
					echo '<div class="following-post">';
					$featured_image_size = 'tenocation-featured-small-thumbnail';
				}
				// adding the class name upon thumbnail availablility
				if (has_post_thumbnail()) {
					$class = 'has-featured-image';
				} else {
					$class = 'no-featured-image';
				}
				?>
				<div class="single-article-content clear">
					<div class="posts-column-wrapper <?php echo esc_attr($class); ?>">
						<?php if ($i == 1) { ?>
							<div class="category-links">
								<?php tenocation_colored_category(); ?>
							</div><!-- .entry-meta -->
						<?php } ?>

						<?php if (has_post_thumbnail()) { ?>
							<figure class="featured-image">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail($featured_image_size); ?></a>
							</figure>
						<?php } ?>

						<div class="category-title-meta-wrapper">
							<h3 class="entry-title">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
							</h3>
							<div class="entry-meta">
								<?php tenocation_widget_posts_posted_on(); ?>
							</div>
						</div>
					</div>

					<?php if ($i == 1) { ?>
						<div class="entry-content">
							<?php the_excerpt(); ?>
						</div>
					<?php } ?>

				</div>
				<?php
				if ($i == 1) {
					echo '</div>';
				}
				$i++;
			endwhile;
			if ($i > 2) {
				echo '</div>';
			}
			// Reset Post Data
			wp_reset_postdata();
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

class tenocation_Posts_Extended_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
				'tenocation_Posts_Extended_Widget', esc_html__('tenocation: Posts Extended Widget', 'tenocation'), // Name of the widget
				array('description' => esc_html__('Displays the latest posts or posts from certain category chosen to display the posts and its excerpt.', 'tenocation'), 'classname' => 'widget-entry-meta tenocation-posts-extended-widget clear') // Arguments of the widget, here it is provided with the description
		);
	}

	function form($instance) {
		$title = !empty($instance['title']) ? $instance['title'] : '';
		$text = !empty($instance['text']) ? $instance['text'] : '';
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		$type = !empty($instance['type']) ? $instance['type'] : 'latest';
		$category = !empty($instance['category']) ? $instance['category'] : '';
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e('Description', 'tenocation'); ?></label>
			<textarea class="widefat" rows="5" cols="20" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>"><?php echo esc_attr($text); ?></textarea>
		</p>

		<p>
			<label>
				<input type="radio" <?php checked($type, 'latest') ?> id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" value="latest"><?php esc_html_e('Show latest posts.', 'tenocation'); ?>
			</label>
			<br/>
			<label>
				<input type="radio" <?php checked($type, 'category') ?> id="<?php echo esc_attr($this->get_field_id('type')); ?>" name="<?php echo esc_attr($this->get_field_name('type')); ?>" value="category"><?php esc_html_e('Show posts from a certain category.', 'tenocation'); ?>
			</label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('category')); ?>"><?php esc_html_e('Select the category:', 'tenocation'); ?>
				<?php
				wp_dropdown_categories(array(
					'show_option_none' => ' ',
					'name' => $this->get_field_name('category'),
					'selected' => $category
				));
				?>
			</label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts to display:', 'tenocation'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr(absint($number)); ?>" size="3">
		</p>
		<?php
	}

	function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['text'] = sanitize_text_field($new_instance['text']);
		$instance['number'] = !empty($new_instance['number']) ? absint($new_instance['number']) : 5;
		$instance['type'] = sanitize_key($new_instance['type']);
		$instance['category'] = absint($new_instance['category']);

		return $instance;
	}

	function widget($args, $instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
		$text = isset($instance['text']) ? $instance['text'] : '';
		$number = !empty($instance['number']) ? $instance['number'] : 5;
		$type = isset($instance['type']) ? $instance['type'] : 'latest';
		$category = isset($instance['category']) ? $instance['category'] : '';

		echo wp_kses_post($args['before_widget']);
		?>
		<?php
		global $post;
		if ($type == 'latest') {
			$category_extended = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'no_found_rows' => true
			));
		} else {
			$category_extended = new WP_Query(array(
				'posts_per_page' => $number,
				'post_type' => 'post',
				'ignore_sticky_posts' => true,
				'category__in' => $category,
				'no_found_rows' => true
			));
		}
		?>

		<?php
		if ($type != 'latest') {
			$border_color = 'style="border-bottom-color:' . tenocation_category_color($category) . ';"';
			$title_color = 'style="background-color:' . tenocation_category_color($category) . ';"';
		} else {
			$border_color = '';
			$title_color = '';
		}

		if (!empty($title)) {
			echo '<h3 class="widget-title" ' . wp_kses_post($border_color) . '><span ' . wp_kses_post($title_color) . '>' . esc_html($title) . '</span></h3>';
		}
		if (!empty($text)) {
			?>
			<p><?php echo esc_html($text); ?></p>
		<?php } ?>

		<div class="tenocation-extended-posts-widget">
			<?php
			while ($category_extended->have_posts()) :
				$category_extended->the_post();
				// adding the class name upon thumbnail availablility
				if (has_post_thumbnail()) {
					$class = 'has-featured-image';
				} else {
					$class = 'no-featured-image';
				}
				?>
				<div class="single-article-content clear">
					<div class="posts-column-wrapper <?php echo esc_attr($class); ?>">
						<div class="category-links">
							<?php tenocation_colored_category(); ?>
						</div><!-- .entry-meta -->

						<?php if (has_post_thumbnail()) { ?>
							<figure class="featured-image">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('tenocation-featured-medium-thumbnail'); ?></a>
							</figure>
						<?php } ?>

						<div class="post-details">
							<h3 class="entry-title">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
							</h3>
							<div class="entry-meta">
								<?php tenocation_widget_posts_posted_on(); ?>
							</div>
							<div class="entry-content">
								<?php the_excerpt(); ?>
							</div>
						</div>
					</div>

				</div>
				<?php
			endwhile;
			// Reset Post Data
			wp_reset_postdata();
			?>
		</div>
		<?php
		echo wp_kses_post($args['after_widget']);
	}

}

?>
