<?php

/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Tenocation
 */
if (!function_exists('tenocation_posted_on')) :

	/**
	 * Prints HTML with meta information for the current post-date/time and author.
	 */
	function tenocation_posted_on() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if (get_the_time('U') !== get_the_modified_time('U')) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf($time_string, esc_attr(get_the_date('c')), esc_html(get_the_date()), esc_attr(get_the_modified_date('c')), esc_html(get_the_modified_date()) );

		$posted_on = sprintf(
				'%s', '<span class="entry-meta-left-calendar"><a href="' . esc_url(get_permalink()) . '" rel="bookmark"><i class="fa fa-calendar"></i></a></span>' . '<span class="entry-meta-left-section">' . '<p rel="bookmark">' . esc_html(get_the_date(get_option( 'date_format' ))) . '</p></span>'
		);

		$byline = sprintf(
				'%s', '<span class="entry-meta-left-author"><a href="' . get_author_posts_url(get_the_author_meta('ID')) . '" rel="bookmark"><i class="fa fa-user"></i></a> </span>' . '<span class="entry-meta-left-section">'. '<span class="author vcard"><a class="url fn n" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . esc_html(get_the_author()) . '</a></span></span>'
		);

		echo '<span class="byline"> ' . wp_kses_post($byline) . '</span>';

		echo '<span class="posted-on">' . wp_kses_post($posted_on) . '</span>'; // WPCS: XSS OK.

		if (!has_post_thumbnail() && (is_single() && !post_password_required() && (comments_open() || get_comments_number()))) {
			echo '<span class="comments-link">';
			echo '<span class="entry-meta-left-comments">';
			comments_popup_link(wp_kses(__('<i class="fa fa-comment"></i>', 'tenocation'), array('i' => array('class' => array()))), wp_kses(__('<i class="fa fa-comment"></i>', 'tenocation'), array('i' => array('class' => array()))), wp_kses(__('<i class="fa fa-comment"></i>', 'tenocation'), array('i' => array('class' => array()))), '', wp_kses(__('<i class="fa fa-comment"></i>', 'tenocation'), array('i' => array('class' => array()))));
			echo '</span>';

			echo '<span class="entry-meta-left-section">';
			comments_popup_link(esc_html__('Leave a reply', 'tenocation'), esc_html__('1 Comment', 'tenocation'), esc_html__('% Comments', 'tenocation'), '', esc_html__('Comments Disabled', 'tenocation'));
			echo '</span>';
			echo '</span>';
		}
	}

endif;

if (!function_exists('tenocation_entry_footer')) :

	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function tenocation_entry_footer() {
		// Hide category and tag text for pages.
		if ('post' === get_post_type()) {
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list('', esc_html__(', ', 'tenocation'));
			if ($tags_list) {
				printf('<span class="tags-links"><i class="fa fa-tags"></i>' . esc_html('%1$s') . '</span>', $tags_list); // WPCS: XSS OK.
			}
		}

		edit_post_link(
				wp_kses(sprintf(
								/* translators: %s: Name of current post */
								__('<i class="fa fa-edit"></i>Edit %s', 'tenocation'), the_title('<span class="screen-reader-text">"', '"</span>', false)
						), array('i' => array('class' => array()), 'span' => array('class' => array()))), '<span class="edit-link">', '</span>'
		);
	}

endif;

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function tenocation_categorized_blog() {
	if (false === ( $all_the_cool_cats = get_transient('tenocation_categories') )) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories(array(
			'fields' => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number' => 2,
		));

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count($all_the_cool_cats);

		set_transient('tenocation_categories', $all_the_cool_cats);
	}

	if ($all_the_cool_cats > 1) {
		// This blog has more than 1 category so tenocation_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so tenocation_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in tenocation_categorized_blog.
 */
function tenocation_category_transient_flusher() {
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient('tenocation_categories');
}

add_action('edit_category', 'tenocation_category_transient_flusher');
add_action('save_post', 'tenocation_category_transient_flusher');
