<?php
/**
 * This fucntion is used to create custom meta boxes in pages/posts to render the left/right sidebar
 *
 * @package Tenocation
 */
add_action('add_meta_boxes', 'tenocation_custom_meta_boxes');

/**
 * Adding the Custom Meta Box
 */
function tenocation_custom_meta_boxes() {
	// Adding the layout meta box for single page
	add_meta_box('page-layout', esc_html__('Select Layout', 'tenocation'), 'tenocation_page_layout', 'page', 'side', 'default');
	// Adding the layout meta box for single post page
	add_meta_box('page-layout', esc_html__('Select Layout', 'tenocation'), 'tenocation_page_layout', 'post', 'side', 'default');
}

/**
 * Adding the sidebar display of the meta option in the editor
 */
global $tenocation_page_layout;
$tenocation_page_layout = array(
	'default-layout' => array(
		'id' => 'tenocation_page_layout',
		'value' => 'default_layout',
		'label' => esc_html__('Default Layout', 'tenocation'),
	),
	'right-sidebar' => array(
		'id' => 'tenocation_page_layout',
		'value' => 'right_sidebar',
		'label' => esc_html__('Right Sidebar', 'tenocation'),
	),
	'left-sidebar' => array(
		'id' => 'tenocation_page_layout',
		'value' => 'left_sidebar',
		'label' => esc_html__('Left Sidebar', 'tenocation'),
	),
	'no-sidebar-full-width' => array(
		'id' => 'tenocation_page_layout',
		'value' => 'no_sidebar_full_width',
		'label' => esc_html__('No Sidebar Full Width', 'tenocation'),
	),
	'no-sidebar-content-centered' => array(
		'id' => 'tenocation_page_layout',
		'value' => 'no_sidebar_content_centered',
		'label' => esc_html__('No Sidebar Content Centered', 'tenocation'),
	),
);

/**
 * Displaying the metabox in the editor section for select layout option of the post/page individually
 */
function tenocation_page_layout() {
	global $tenocation_page_layout, $post;

	// Use nonce for verification
	wp_nonce_field(basename(__FILE__), 'custom_meta_box_nonce');

	foreach ($tenocation_page_layout as $field) {
		$tenocation_layout_meta = get_post_meta($post->ID, $field['id'], true);
		if (empty($tenocation_layout_meta)) {
			$tenocation_layout_meta = 'default_layout';
		}
		?>
		<input class="post-format" id="<?php echo esc_attr($field['value']); ?>" type="radio" name="<?php echo esc_attr($field['id']); ?>" value="<?php echo esc_attr($field['value']); ?>" <?php checked($field['value'], $tenocation_layout_meta); ?>/>
		<label for="<?php echo esc_attr($field['value']); ?>" class="post-format-icon"><?php echo esc_html($field['label']); ?></label><br/>
		<?php
	}
}

/**
 * Save the custom metabox data
 */
if (!function_exists('tenocation_save_custom_meta_data')) :

	function tenocation_save_custom_meta_data($post_id) {
		global $tenocation_page_layout, $post;

		// Verify the nonce before proceeding.
		$tenocation_metabox_nonce = '';
		if (isset($_POST['custom_meta_box_nonce'])) {
			$tenocation_metabox_nonce = sanitize_text_field(wp_unslash($_POST['custom_meta_box_nonce']));
		}
		if (!$tenocation_metabox_nonce || !wp_verify_nonce($tenocation_metabox_nonce, basename(__FILE__))) {
			return;
		}

		// Stop WP from clearing custom fields on autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return;
		}

		$tenocation_post_type = '';
		if (isset($_POST['post_type'])) {
			$tenocation_post_type = sanitize_text_field(wp_unslash($_POST['post_type']));
		}
		if ('page' == $tenocation_post_type) {
			if (!current_user_can('edit_page', $post_id))
				return $post_id;
		} elseif (!current_user_can('edit_post', $post_id)) {
			return $post_id;
		}

		foreach ($tenocation_page_layout as $field) {
			// Execute this saving function
			$tenocation_field_id = '';
			if (isset($_POST[$field['id']])) {
				$tenocation_field_id = sanitize_key(wp_unslash($_POST[$field['id']]));
			}

			$old_meta_data = get_post_meta($post_id, $field['id'], true);
			$new_meta_data = $tenocation_field_id;
			if ($new_meta_data && $new_meta_data != $old_meta_data) {
				update_post_meta($post_id, $field['id'], $new_meta_data);
			} elseif ('' == $new_meta_data && $old_meta_data) {
				delete_post_meta($post_id, $field['id'], $old_meta_data);
			}
		} // end foreach
	}

endif;

add_action('pre_post_update', 'tenocation_save_custom_meta_data');
