<?php
/**
 * tenocation Theme Customizer.
 *
 * @package Tenocation
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function tenocation_customize_register($wp_customize) {
	$wp_customize->get_setting('blogname')->transport = 'postMessage';
	$wp_customize->get_setting('blogdescription')->transport = 'postMessage';
	$wp_customize->get_setting('header_textcolor')->transport = 'postMessage';

	// Start Of Header Options
	$wp_customize->add_panel('tenocation_header_options', array(
		'capabitity' => 'edit_theme_options',
		'description' => esc_html__('Change the Header Settings from here as you want to best suit your need.', 'tenocation'),
		'priority' => 500,
		'title' => esc_html__('Header Options', 'tenocation')
	));

	// date display enable/disable
	$wp_customize->add_section('tenocation_date_display_section', array(
		'priority' => 1,
		'title' => esc_html__('Show Date', 'tenocation'),
		'panel' => 'tenocation_header_options'
	));

	$wp_customize->add_setting('tenocation_date_display', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_date_display', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to show the date in header area.', 'tenocation'),
		'section' => 'tenocation_date_display_section',
		'settings' => 'tenocation_date_display'
	));

	// date in header display type
	$wp_customize->add_setting('tenocation_date_display_type', array(
		'default' => 'theme_default',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_radio_select_sanitize'
	));

	$wp_customize->add_control('tenocation_date_display_type', array(
		'type' => 'radio',
		'label' => esc_html__('Date in header display type:', 'tenocation'),
		'choices' => array(
			'theme_default' => esc_html__('Theme Default Setting', 'tenocation'),
			'wordpress_date_setting' => esc_html__('WordPress General Date Setting', 'tenocation'),
		),
		'section' => 'tenocation_date_display_section',
		'settings' => 'tenocation_date_display_type'
	));

	// small info text in header
	$wp_customize->add_section('tenocation_header_text_setting', array(
		'priority' => 2,
		'title' => esc_html__('Small Info Text', 'tenocation'),
		'panel' => 'tenocation_header_options'
	));

	$wp_customize->add_setting('tenocation_header_text', array(
		'default' => '',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'wp_kses_post'
	));

	$wp_customize->add_control('tenocation_header_text', array(
		'type' => 'textarea',
		'label' => esc_html__('Write your custom text to display it in the header top bar. It also accepts the shortcodes too.', 'tenocation'),
		'section' => 'tenocation_header_text_setting',
		'settings' => 'tenocation_header_text'
	));

	// home icon display enable/disable
	$wp_customize->add_section('tenocation_home_icon_display_section', array(
		'priority' => 3,
		'title' => esc_html__('Home Icon', 'tenocation'),
		'panel' => 'tenocation_header_options'
	));

	$wp_customize->add_setting('tenocation_home_icon_display', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_home_icon_display', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to add the home icon in the primary menu.', 'tenocation'),
		'section' => 'tenocation_home_icon_display_section',
		'settings' => 'tenocation_home_icon_display'
	));

	// random posts in menu enable/disable
	$wp_customize->add_section('tenocation_random_post_in_menu_section', array(
		'priority' => 4,
		'title' => esc_html__('Random Post', 'tenocation'),
		'panel' => 'tenocation_header_options'
	));

	$wp_customize->add_setting('tenocation_random_post_in_menu', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_random_post_in_menu', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to display the random post icon in the primary menu.', 'tenocation'),
		'section' => 'tenocation_random_post_in_menu_section',
		'settings' => 'tenocation_random_post_in_menu'
	));

	// search icon in menu enable/disable
	$wp_customize->add_section('tenocation_search_icon_in_menu_section', array(
		'priority' => 5,
		'title' => esc_html__('Search Icon', 'tenocation'),
		'panel' => 'tenocation_header_options'
	));

	$wp_customize->add_setting('tenocation_search_icon_in_menu', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_search_icon_in_menu', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to display the search icon in the primary menu.', 'tenocation'),
		'section' => 'tenocation_search_icon_in_menu_section',
		'settings' => 'tenocation_search_icon_in_menu'
	));

	// menu animation using superfish js library enable/disable
	$wp_customize->add_section('tenocation_superfish_menu_section', array(
		'priority' => 6,
		'title' => esc_html__('Menu Animation', 'tenocation'),
		'panel' => 'tenocation_header_options'
	));

	$wp_customize->add_setting('tenocation_superfish_menu', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_superfish_menu', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to enable the animation effect on the primary menu.', 'tenocation'),
		'section' => 'tenocation_superfish_menu_section',
		'settings' => 'tenocation_superfish_menu'
	));

	// sticky menu section
	$wp_customize->add_section('tenocation_sticky_menu_section', array(
		'priority' => 7,
		'title' => esc_html__('Sticky Menu', 'tenocation'),
		'panel' => 'tenocation_header_options'
	));

	// sticky menu enable/disable
	$wp_customize->add_setting('tenocation_sticky_menu_option', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_sticky_menu_option', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to make the primary menu sticky.', 'tenocation'),
		'section' => 'tenocation_sticky_menu_section',
		'settings' => 'tenocation_sticky_menu_option'
	));

	// sticky menu options
	$wp_customize->add_setting('tenocation_sticky_menu_type', array(
		'default' => 'scroll',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_radio_select_sanitize'
	));

	$wp_customize->add_control('tenocation_sticky_menu_type', array(
		'type' => 'radio',
		'label' => esc_html__('Choose the required option to make your menu sticky.', 'tenocation'),
		'choices' => array(
			'scroll' => esc_html__('Make the menu reveal on scroll up.', 'tenocation'),
			'sticky' => esc_html__('Make the menu sticky, ie, always stick the menu in top.', 'tenocation')
		),
		'section' => 'tenocation_sticky_menu_section',
		'settings' => 'tenocation_sticky_menu_type'
	));

	// breaking news option enable/disable
	$wp_customize->add_section('tenocation_breaking_news_section', array(
		'priority' => 8,
		'title' => esc_html__('Breaking News', 'tenocation'),
		'panel' => 'tenocation_header_options'
	));

	$wp_customize->add_setting('tenocation_breaking_news', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_breaking_news', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to enable the breaking news section.', 'tenocation'),
		'section' => 'tenocation_breaking_news_section',
		'settings' => 'tenocation_breaking_news'
	));
	// End Of Header Options
	// Start Of Design Options
	$wp_customize->add_panel('tenocation_design_options', array(
		'capabitity' => 'edit_theme_options',
		'description' => esc_html__('Change the Design Settings from here as you want to best suit your need.', 'tenocation'),
		'priority' => 505,
		'title' => esc_html__('Design Options', 'tenocation')
	));

	// site layout setting
	$wp_customize->add_section('tenocation_site_layout_setting', array(
		'priority' => 1,
		'title' => esc_html__('Site Layout', 'tenocation'),
		'panel' => 'tenocation_design_options'
	));

	$wp_customize->add_setting('tenocation_site_layout', array(
		'default' => 'wide_layout',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_radio_select_sanitize'
	));

	$wp_customize->add_control('tenocation_site_layout', array(
		'type' => 'radio',
		'label' => esc_html__('Choose your site layout. The change is reflected in the whole site.', 'tenocation'),
		'choices' => array(
			'boxed_layout' => esc_html__('Boxed Layout', 'tenocation'),
			'wide_layout' => esc_html__('Wide Layout', 'tenocation')
		),
		'section' => 'tenocation_site_layout_setting'
	));

	// layout option
	class tenocation_Image_Radio_Control extends WP_Customize_Control {

		public function render_content() {

			if (empty($this->choices))
				return;

			$name = '_customize-radio-' . $this->id;
			?>
			<span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
			<ul class="controls" id='tenocation-img-container'>
				<?php
				foreach ($this->choices as $value => $label) :
					$class = ($this->value() == $value) ? 'tenocation-radio-img-selected tenocation-radio-img-img' : 'tenocation-radio-img-img';
					?>
					<li style="display: inline;">
						<label>
							<input <?php $this->link(); ?>style = 'display:none' type="radio" value="<?php echo esc_attr($value); ?>" name="<?php echo esc_attr($name); ?>" <?php
														  $this->link();
														  checked($this->value(), $value);
														  ?> />
							<img src='<?php echo esc_url($label); ?>' class='<?php echo esc_attr($class); ?>' />
						</label>
					</li>
					<?php
				endforeach;
				?>
			</ul>
			<?php
		}

	}

	// default layout setting
	$wp_customize->add_section('tenocation_default_layout_setting', array(
		'priority' => 2,
		'title' => esc_html__('Default layout', 'tenocation'),
		'panel' => 'tenocation_design_options'
	));

	$wp_customize->add_setting('tenocation_default_layout', array(
		'default' => 'right_sidebar',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_radio_select_sanitize'
	));

	$wp_customize->add_control(new tenocation_Image_Radio_Control($wp_customize, 'tenocation_default_layout', array(
		'type' => 'radio',
		'label' => esc_html__('Select default layout. This layout will be reflected in whole site archives, categories, search page etc. The layout for a single post and page can be controlled from the other options available in this theme.', 'tenocation'),
		'section' => 'tenocation_default_layout_setting',
		'settings' => 'tenocation_default_layout',
		'choices' => array(
			'right_sidebar' => get_template_directory_uri() . '/img/right-sidebar.png',
			'left_sidebar' => get_template_directory_uri() . '/img/left-sidebar.png',
			'no_sidebar_full_width' => get_template_directory_uri() . '/img/no-sidebar-full-width-layout.png',
			'no_sidebar_content_centered' => get_template_directory_uri() . '/img/no-sidebar-content-centered-layout.png'
		)
	)));

	// default layout for pages
	$wp_customize->add_section('tenocation_default_page_layout_setting', array(
		'priority' => 3,
		'title' => esc_html__('Default layout for pages only', 'tenocation'),
		'panel' => 'tenocation_design_options'
	));

	$wp_customize->add_setting('tenocation_default_page_layout', array(
		'default' => 'right_sidebar',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_radio_select_sanitize'
	));

	$wp_customize->add_control(new tenocation_Image_Radio_Control($wp_customize, 'tenocation_default_page_layout', array(
		'type' => 'radio',
		'label' => esc_html__('Select default layout for pages. This layout will be reflected in all pages unless unique layout is set for the specific page.', 'tenocation'),
		'section' => 'tenocation_default_page_layout_setting',
		'settings' => 'tenocation_default_page_layout',
		'choices' => array(
			'right_sidebar' => get_template_directory_uri() . '/img/right-sidebar.png',
			'left_sidebar' => get_template_directory_uri() . '/img/left-sidebar.png',
			'no_sidebar_full_width' => get_template_directory_uri() . '/img/no-sidebar-full-width-layout.png',
			'no_sidebar_content_centered' => get_template_directory_uri() . '/img/no-sidebar-content-centered-layout.png'
		)
	)));

	// default layout for single posts
	$wp_customize->add_section('tenocation_default_single_posts_layout_setting', array(
		'priority' => 4,
		'title' => esc_html__('Default layout for single posts only', 'tenocation'),
		'panel' => 'tenocation_design_options'
	));

	$wp_customize->add_setting('tenocation_default_single_posts_layout', array(
		'default' => 'right_sidebar',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_radio_select_sanitize'
	));

	$wp_customize->add_control(new tenocation_Image_Radio_Control($wp_customize, 'tenocation_default_single_posts_layout', array(
		'type' => 'radio',
		'label' => esc_html__('Select default layout for single posts. This layout will be reflected in all single posts unless unique layout is set for the specific post.', 'tenocation'),
		'section' => 'tenocation_default_single_posts_layout_setting',
		'settings' => 'tenocation_default_single_posts_layout',
		'choices' => array(
			'right_sidebar' => get_template_directory_uri() . '/img/right-sidebar.png',
			'left_sidebar' => get_template_directory_uri() . '/img/left-sidebar.png',
			'no_sidebar_full_width' => get_template_directory_uri() . '/img/no-sidebar-full-width-layout.png',
			'no_sidebar_content_centered' => get_template_directory_uri() . '/img/no-sidebar-content-centered-layout.png'
		)
	)));

	if (!function_exists('wp_update_custom_css_post')) {
		// custom CSS setting
		$wp_customize->add_section('tenocation_custom_css_setting', array(
			'priority' => 6,
			'title' => esc_html__('Custom CSS', 'tenocation'),
			'panel' => 'tenocation_design_options'
		));

		$wp_customize->add_setting('tenocation_custom_css', array(
			'default' => '',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'wp_filter_nohtml_kses',
			'sanitize_js_callback' => 'wp_filter_nohtml_kses'
		));

		$wp_customize->add_control('tenocation_custom_css', array(
			'type' => 'textarea',
			'label' => esc_html__('Write your custom css and design live.', 'tenocation'),
			'section' => 'tenocation_custom_css_setting',
			'settings' => 'tenocation_custom_css'
		));
	}
	// End Of Design Options
	// Start of the WordPress default sections for theme related options
	// header image link enable/disable
	$wp_customize->add_setting('tenocation_header_image_link', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_header_image_link', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to enable the header image to link back to the home page.', 'tenocation'),
		'section' => 'header_image',
		'settings' => 'tenocation_header_image_link'
	));

	// primary color options
	$wp_customize->add_setting('tenocation_primary_color', array(
		'default' => '#4169e1',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_color_option_hex_sanitize',
		'sanitize_js_callback' => 'tenocation_color_escaping_option_sanitize'
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tenocation_primary_color', array(
		'label' => esc_html__('Primary Color', 'tenocation'),
		'section' => 'colors',
		'settings' => 'tenocation_primary_color'
	)));

	// End of the WordPress default sections for theme related options
	// Start of Additional Options
	$wp_customize->add_panel('tenocation_additional_options', array(
		'capability' => 'edit_theme_options',
		'description' => esc_html__('Change the Additional Settings from here as you want to best suite your site.', 'tenocation'),
		'priority' => 515,
		'title' => esc_html__('Additional Options', 'tenocation')
	));

	// related posts
	$wp_customize->add_section('tenocation_related_posts_section', array(
		'priority' => 1,
		'title' => esc_html__('Related Posts', 'tenocation'),
		'panel' => 'tenocation_additional_options'
	));

	$wp_customize->add_setting('tenocation_related_posts_activate', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_related_posts_activate', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to activate the related posts.', 'tenocation'),
		'section' => 'tenocation_related_posts_section',
		'settings' => 'tenocation_related_posts_activate'
	));

	$wp_customize->add_setting('tenocation_related_posts', array(
		'default' => 'categories',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_radio_select_sanitize'
	));

	$wp_customize->add_control('tenocation_related_posts', array(
		'type' => 'radio',
		'label' => esc_html__('Related Posts To Be Shown As:', 'tenocation'),
		'section' => 'tenocation_related_posts_section',
		'settings' => 'tenocation_related_posts',
		'choices' => array(
			'categories' => esc_html__('Related Posts By Categories', 'tenocation'),
			'tags' => esc_html__('Related Posts By Tags', 'tenocation')
		)
	));

	// featured image popup check
	$wp_customize->add_section('tenocation_featured_image_popup_setting', array(
		'priority' => 2,
		'title' => esc_html__('Image Lightbox', 'tenocation'),
		'panel' => 'tenocation_additional_options'
	));

	$wp_customize->add_setting('tenocation_featured_image_popup', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_featured_image_popup', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to enable the lightbox feature for the featured images in single post page and pages.', 'tenocation'),
		'section' => 'tenocation_featured_image_popup_setting',
		'settings' => 'tenocation_featured_image_popup'
	));

	// author bio links
	$wp_customize->add_section('tenocation_author_bio_social_links_setting', array(
		'priority' => 3,
		'title' => esc_html__('Social Links In Author Bio', 'tenocation'),
		'panel' => 'tenocation_additional_options'
	));

	$wp_customize->add_setting('tenocation_author_bio_social_links', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_author_bio_social_links', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to enable the social links in the Author Bio section. For this to work, you need to add the URL of your social sites in the profile section. This theme supports WordPress SEO and All In One SEO Pack plugin for this feature.', 'tenocation'),
		'section' => 'tenocation_author_bio_social_links_setting',
		'settings' => 'tenocation_author_bio_social_links'
	));

	// Sticky Sidebar and Content area
	$wp_customize->add_section('tenocation_sticky_sidebar_content_setting', array(
		'priority' => 3,
		'title' => esc_html__('Sticky Sidebar And Content Area', 'tenocation'),
		'panel' => 'tenocation_additional_options'
	));

	$wp_customize->add_setting('tenocation_sticky_sidebar_content', array(
		'default' => 0,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'tenocation_checkbox_sanitize'
	));

	$wp_customize->add_control('tenocation_sticky_sidebar_content', array(
		'type' => 'checkbox',
		'label' => esc_html__('Check to enable the feature of sticky sidebar and content area.', 'tenocation'),
		'section' => 'tenocation_sticky_sidebar_content_setting',
		'settings' => 'tenocation_sticky_sidebar_content'
	));
	// End of Additional Options
	// Category Color Options
	$wp_customize->add_panel('tenocation_category_color_panel', array(
		'priority' => 700,
		'title' => esc_html__('Category Color Options', 'tenocation'),
		'capability' => 'edit_theme_options',
		'description' => esc_html__('Change the color of each category items as you want to best suit your site requirement.', 'tenocation')
	));

	$wp_customize->add_section('tenocation_category_color_setting', array(
		'priority' => 1,
		'title' => esc_html__('Category Color Settings', 'tenocation'),
		'panel' => 'tenocation_category_color_panel'
	));

	$i = 1;
	$args = array(
		'orderby' => 'id',
		'hide_empty' => 1
	);
	$categories = get_categories($args);
	$wp_category_list = array();

	// looping through each category colors
	foreach ($categories as $category_list) {
		$wp_category_list[$category_list->cat_ID] = $category_list->cat_name;

		$wp_customize->add_setting('tenocation_category_color_' . get_cat_id($wp_category_list[$category_list->cat_ID]), array(
			'default' => '',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'tenocation_color_option_hex_sanitize',
			'sanitize_js_callback' => 'tenocation_color_escaping_option_sanitize'
		));
		/* translators: %s: for category list */ 
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tenocation_category_color_' . get_cat_id($wp_category_list[$category_list->cat_ID]), array(
			'label' => sprintf(esc_html('%s'), $wp_category_list[$category_list->cat_ID]),
			'section' => 'tenocation_category_color_setting',
			'settings' => 'tenocation_category_color_' . get_cat_id($wp_category_list[$category_list->cat_ID]),
			'priority' => $i
		)));
		$i++;
	}

	// End Of Category Color Options
	// sanitization works
	// radio/select buttons sanitization
	function tenocation_radio_select_sanitize($input, $setting) {
		// Ensuring that the input is a slug.
		$input = sanitize_key($input);
		// Get the list of choices from the control associated with the setting.
		$choices = $setting->manager->get_control($setting->id)->choices;
		// If the input is a valid key, return it, else, return the default.
		return ( array_key_exists($input, $choices) ? $input : $setting->default );
	}

	// checkbox sanitization
	function tenocation_checkbox_sanitize($input) {
		return (1 === absint($input)) ? 1 : 0;
	}

	// color sanitization
	function tenocation_color_option_hex_sanitize($color) {
		if ($unhashed = sanitize_hex_color_no_hash($color))
			return '#' . $unhashed;

		return $color;
	}

	function tenocation_color_escaping_option_sanitize($input) {
		$input = sanitize_hex_color($input);
		return $input;
	}

	// link sanitization
	function tenocation_important_links_sanitize() {
		return false;
	}

}

add_action('customize_register', 'tenocation_customize_register');

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function tenocation_customize_preview_js() {
	// adding the function to load the minified version if SCRIPT_DEFUG is disable
	$suffix = ( defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script('tenocation_customizer', get_template_directory_uri() . '/js/tenocation-customizer' . $suffix . '.js', array('customize-preview'), '20151215', true);
}

add_action('customize_preview_init', 'tenocation_customize_preview_js');
