<?php

/**
 * tenocation functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Tenocation
 */
if (!function_exists('tenocation_setup')) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function tenocation_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on teocation, use a find and replace
		 * to change 'tenocation' to the name of your theme in all the template files.
		 */
		load_theme_textdomain('tenocation', get_template_directory() . '/languages');

		// Add default posts and comments RSS feed links to head.
		add_theme_support('automatic-feed-links');

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support('title-tag');

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support('post-thumbnails');
		add_image_size('tenocation-featured-small-thumbnail', 120, 90, true);
		add_image_size('tenocation-featured-medium-thumbnail', 600, 450, true);
		add_image_size('tenocation-featured-large-thumbnail', 800, 600, true);
		add_image_size('tenocation-featured-related-posts-thumbnail', 400, 300, true);

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(array(
			'primary' => esc_html__('Primary Menu', 'tenocation'),
			'social' => esc_html__('Social Menu', 'tenocation'),
			'footer' => esc_html__('Footer Menu', 'tenocation')
		));

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support('html5', array(/*
			'search-form',*/
			'comment-form',
			'comment-list',/*
			'gallery',*/
			'caption',
		));

		/*
		 * Enable support for Post Formats.
		 * See https://developer.wordpress.org/themes/functionality/post-formats/
		 */
		add_theme_support('post-formats', array(
			'aside',
			'image',
			'video',
			'quote',
			'link',
			'gallery',
			'chat',
			'audio',
			'status'
		));

		// Set up the WordPress core custom background feature.
		add_theme_support('custom-background', apply_filters('tenocation_custom_background_args', array(
			'default-color' => 'ccc',
			'default-image' => '',
		)));

		// Set up the WordPress core custom logo feature.
		add_theme_support('custom-logo', array(
			'height' => 100,
			'width' => 300,
			'flex-width' => true,
			'flex-height' => true,
		));

		// Add theme support for selective refresh for widgets.
		add_theme_support('customize-selective-refresh-widgets');

		// Add theme support for WooCommerce plugin
		add_theme_support('woocommerce');
		add_theme_support('wc-product-gallery-zoom');
		add_theme_support('wc-product-gallery-lightbox');
		add_theme_support('wc-product-gallery-slider');
	}

endif;
add_action('after_setup_theme', 'tenocation_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function tenocation_content_width() {
	$GLOBALS['content_width'] = apply_filters('tenocation_content_width', 800);
}

add_action('after_setup_theme', 'tenocation_content_width', 0);

/**
 * $content_width global variable adjustment as per layout option.
 */
function tenocation_dynamic_content_width() {
	global $post;
	global $content_width;

	if ($post) {
		$tenocation_layout_meta = get_post_meta($post->ID, 'tenocation_page_layout', true);
	}

	if (is_home()) {
		$queried_id = get_option('page_for_posts');
		$tenocation_layout_meta = get_post_meta($queried_id, 'tenocation_page_layout', true);
	}

	if (empty($tenocation_layout_meta) || is_archive() || is_search() || is_404()) {
		$tenocation_layout_meta = 'default_layout';
	}

	$tenocation_default_layout = get_theme_mod('tenocation_default_layout', 'right_sidebar');
	$tenocation_default_page_layout = get_theme_mod('tenocation_default_page_layout', 'right_sidebar');
	$tenocation_default_post_layout = get_theme_mod('tenocation_default_single_posts_layout', 'right_sidebar');

	if ($tenocation_layout_meta == 'default_layout') {
		if (is_page()) {
			if ($tenocation_default_page_layout == 'no_sidebar_full_width') {
				$content_width = 1160; /* pixels */
			} else {
				$content_width = 800; /* pixels */
			}
		} elseif (is_single()) {
			if ($tenocation_default_post_layout == 'no_sidebar_full_width') {
				$content_width = 1160; /* pixels */
			} else {
				$content_width = 800; /* pixels */
			}
		} elseif ($tenocation_default_layout == 'no_sidebar_full_width') {
			$content_width = 1160; /* pixels */
		} else {
			$content_width = 800; /* pixels */
		}
	} elseif ($tenocation_layout_meta == 'no_sidebar_full_width') {
		$content_width = 1160; /* pixels */
	} else {
		$content_width = 800; /* pixels */
	}
}

add_action('template_redirect', 'tenocation_dynamic_content_width');

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function tenocation_widgets_init() {
	// registering the right sidebar area
	register_sidebar(array(
		'name' => esc_html__('Right Sidebar', 'tenocation'),
		'id' => 'tenocation-right-sidebar',
		'description' => esc_html__('Display your widgets in the Right Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the left sidebar area
	register_sidebar(array(
		'name' => esc_html__('Left Sidebar', 'tenocation'),
		'id' => 'tenocation-left-sidebar',
		'description' => esc_html__('Display your widgets in the Left Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the header sidebar area
	register_sidebar(array(
		'name' => esc_html__('Header Sidebar', 'tenocation'),
		'id' => 'tenocation-header-sidebar',
		'description' => esc_html__('Display your widgets in the Header Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the magazine slider sidebar area
	register_sidebar(array(
		'name' => esc_html__('Magazine Slider Sidebar', 'tenocation'),
		'id' => 'tenocation-magazine-slider-sidebar',
		'description' => esc_html__('Display your widgets in the Magazine Slider Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the magazine beside slider sidebar area
	register_sidebar(array(
		'name' => esc_html__('Magazine Beside Slider Sidebar', 'tenocation'),
		'id' => 'tenocation-magazine-beside-slider-sidebar',
		'description' => esc_html__('Display your widgets in the Magazine Beside Slider Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the magazine top content sidebar area
	register_sidebar(array(
		'name' => esc_html__('Magazine Top Content Sidebar', 'tenocation'),
		'id' => 'tenocation-magazine-top-content-sidebar',
		'description' => esc_html__('Display your widgets in the Magazine Top Content Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the magazine content middle left sidebar area
	register_sidebar(array(
		'name' => esc_html__('Magazine Middle Left Sidebar', 'tenocation'),
		'id' => 'tenocation-magazine-middle-left-sidebar',
		'description' => esc_html__('Display your widgets in the Magazine Middle Left Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the magazine content middle right sidebar area
	register_sidebar(array(
		'name' => esc_html__('Magazine Middle Right Sidebar', 'tenocation'),
		'id' => 'tenocation-magazine-middle-right-sidebar',
		'description' => esc_html__('Display your widgets in the Magazine Middle Right Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the magazine bottom content sidebar area
	register_sidebar(array(
		'name' => esc_html__('Magazine Bottom Content Sidebar', 'tenocation'),
		'id' => 'tenocation-magazine-bottom-content-sidebar',
		'description' => esc_html__('Display your widgets in the Magazine Bottom Content Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the content top sidebar area
	register_sidebar(array(
		'name' => esc_html__('Content Top Sidebar', 'tenocation'),
		'id' => 'tenocation-content-top-sidebar',
		'description' => esc_html__('Display your widgets in the Content Top Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the content bottom sidebar area
	register_sidebar(array(
		'name' => esc_html__('Content Bottom Sidebar', 'tenocation'),
		'id' => 'tenocation-content-bottom-sidebar',
		'description' => esc_html__('Display your widgets in the Content Bottom Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the 404 page sidebar area
	register_sidebar(array(
		'name' => esc_html__('404 Sidebar', 'tenocation'),
		'id' => 'tenocation-404-sidebar',
		'description' => esc_html__('Display your widgets in the 404 Error Page Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the contact page sidebar area
	register_sidebar(array(
		'name' => esc_html__('Contact Page Sidebar', 'tenocation'),
		'id' => 'tenocation-contact-page-sidebar',
		'description' => esc_html__('Display your widgets in the Contact Page Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the large footer sidebar area
	register_sidebar(array(
		'name' => esc_html__('Large Footer Sidebar', 'tenocation'),
		'id' => 'tenocation-large-footer-sidebar',
		'description' => esc_html__('Display your widgets in the Large Footer Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the smaller footer sidebar area one
	register_sidebar(array(
		'name' => esc_html__('Small Footer Sidebar One', 'tenocation'),
		'id' => 'tenocation-small-footer-sidebar-one',
		'description' => esc_html__('Display your widgets in the Small Footer Sidebar Area One.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the smaller footer sidebar area one
	register_sidebar(array(
		'name' => esc_html__('Small Footer Sidebar Two', 'tenocation'),
		'id' => 'tenocation-small-footer-sidebar-two',
		'description' => esc_html__('Display your widgets in the Small Footer Sidebar Area Two.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	// registering the masonry footer sidebar area
	register_sidebar(array(
		'name' => esc_html__('Masonry Footer Sidebar', 'tenocation'),
		'id' => 'tenocation-masonry-footer-sidebar',
		'description' => esc_html__('Display your widgets in the Masonry Footer Sidebar Area.', 'tenocation'),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<h3 class="widget-title"><span>',
		'after_title' => '</span></h3>',
	));

	register_widget('tenocation_random_posts_Widget');
	register_widget('tenocation_Tabbed_Widget');
	register_widget('tenocation_Posts_Slider_Widget');
	register_widget('tenocation_Posts_Grid_Widget');
	register_widget('tenocation_Posts_One_Column_Widget');
	register_widget('tenocation_Posts_Two_Column_Widget');
	register_widget('tenocation_Posts_Extended_Widget');
}

add_action('widgets_init', 'tenocation_widgets_init');

/**
 * Enqueue scripts and styles.
 */
if (!function_exists('tenocation_fonts_url')) {

	// Using google font
	// creating the function for adding the google font url
	function tenocation_fonts_url() {
		$fonts_url = '';
		$fonts = array();
		$subsets = 'latin,latin-ext';
		// applying the translators for the Google Fonts used
		/* Translators: If there are characters in your language that are not
		 * supported by Noto Sans, translate this to 'off'. Do not translate
		 * into your own language.
		 */
		if ('off' !== _x('on', 'Noto Sans font: on or off', 'tenocation')) {
			$fonts[] = 'Noto Sans:400,400italic,700,700italic';
		}

		/* Translators: If there are characters in your language that are not
		 * supported by Lobster Two, translate this to 'off'. Do not translate
		 * into your own language.
		 */
		if ('off' !== _x('on', 'Lobster Two font: on or off', 'tenocation')) {
			$fonts[] = 'Lobster Two:400,400italic,700,700italic';
		}

		/*
		 * Translators: To add an additional character subset specific to your language,
		 * translate this to 'cyrillic'. Do not translate into your own language.
		 */
		$subset = _x('no-subset', 'Add new subset ( cyrillic, greek, vietnamese, devanagari )', 'tenocation');

		if ('cyrillic' == $subset) {
			$subsets .= ',cyrillic,cyrillic-ext';
		} elseif ('greek' == $subset) {
			$subsets .= ',greek-ext,greek';
		} elseif ('vietnamese' == $subset) {
			$subsets .= ',vietnamese';
		} elseif ('devanagari' == $subset) {
			$subsets .= ',devanagari';
		}

		// Ready to enqueue Google Font
		if ($fonts) {
			$fonts_url = add_query_arg(array(
				'family' => urlencode(implode('|', $fonts)),
				'subset' => urlencode($subsets),
					), '//fonts.googleapis.com/css');
		}
		return $fonts_url;
	}

}
// completion of enqueue for the google font

/**
 * Enqueue scripts and styles.
 */
function tenocation_scripts() {

	// adding the function to load the minified version if SCRIPT_DEFUG is disable
	$suffix = ( defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ) ? '' : '.min';

	// use of enqueued google fonts
	wp_enqueue_style('tenocation-google-fonts', tenocation_fonts_url(), array(), null);

	// enqueueing the main stylesheet file
	wp_enqueue_style('tenocation-style', get_stylesheet_uri());

	// enqueueing the fontawesome icons
	wp_enqueue_style('font-awesome', get_template_directory_uri() . '/fontawesome/css/font-awesome' . $suffix . '.css');

	// registering the bxslider script
	wp_register_script('jquery-bxslider', get_template_directory_uri() . '/js/jquery.bxslider/jquery.bxslider' . $suffix . '.js', array('jquery'), null, true);

	// enqueueing the fitvids javascript file
	wp_enqueue_script('jquery-fitvids', get_template_directory_uri() . '/js/fitvids/jquery.fitvids' . $suffix . '.js', array('jquery'), false, true);

	if (is_active_sidebar('tenocation-masonry-footer-sidebar')) {
		wp_enqueue_script('jquery-masonry');
	}

	// menu animation using superfish
	if (get_theme_mod('tenocation_superfish_menu', 0) == 1) {
		// enqueueing the superfish script
		wp_enqueue_script('superfish', get_template_directory_uri() . '/js/superfish/superfish' . $suffix . '.js', array(), false, true);
		// enqueueing the enquire script
		wp_enqueue_script('enquire', get_template_directory_uri() . '/js/enquire/enquire' . $suffix . '.js', array(), false, true);
	}

	if (get_theme_mod('tenocation_sticky_menu_option', 0) == 1) {
		if (get_theme_mod('tenocation_sticky_menu_type', 'scroll') == 'scroll') {
			// enqueueing the headroom script
			wp_enqueue_script('headroom', get_template_directory_uri() . '/js/headroom/headroom' . $suffix . '.js', array(), false, true);
			wp_enqueue_script('jquery-headroom', get_template_directory_uri() . '/js/headroom/jQuery.headroom' . $suffix . '.js', array(), false, true);
		} elseif (get_theme_mod('tenocation_sticky_menu_type', 'scroll') == 'sticky') {
			// enqueueing the stickyjs script
			wp_enqueue_script('jquery-sticky', get_template_directory_uri() . '/js/sticky/jquery.sticky' . $suffix . '.js', array('jquery'), false, true);
		}
	}

	// enqueueing the bxslider for breaking news
	if (get_theme_mod('tenocation_breaking_news', 0) == 1 || has_post_format('gallery') || is_home() || is_search() || is_archive()) {
		wp_enqueue_script('jquery-bxslider');
	}

	// enqueueing magnific popup
	if ((get_theme_mod('tenocation_featured_image_popup', 0) == 1) && has_post_thumbnail() && (is_single() || is_page())) {
		wp_enqueue_script('jquery-magnific-popup', get_template_directory_uri() . '/js/magnific-popup/jquery.magnific-popup' . $suffix . '.js', array('jquery'), null, true);
		wp_enqueue_style('magnific-popup', get_template_directory_uri() . '/js/magnific-popup/magnific-popup' . $suffix . '.css');
	}

	// enqueueing sticky content and sidebar area required js files
	if (get_theme_mod('tenocation_sticky_sidebar_content', 0) == 1) {
		wp_enqueue_script('ResizeSensor', get_template_directory_uri() . '/js/theia-sticky-sidebar/ResizeSensor' . $suffix . '.js', array('jquery'), false, true);
		wp_enqueue_script('theia-sticky-sidebar', get_template_directory_uri() . '/js/theia-sticky-sidebar/theia-sticky-sidebar' . $suffix . '.js', array('jquery'), false, true);
	}

	// enqueueing the navigation script
	wp_enqueue_script('tenocation-navigation', get_template_directory_uri() . '/js/tenocation-navigation' . $suffix . '.js', array(), '20151215', true);

	// enqueueing the skip link focus fix script
	wp_enqueue_script('tenocation-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix' . $suffix . '.js', array(), '20151215', true);

	// enqueueing the theme's main javascript file
	wp_enqueue_script('tenocation-main-script', get_template_directory_uri() . '/js/tenocation-custom' . $suffix . '.js', array('jquery'), false, true);

	// enqueueing the comment reply script
	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}

	// loading the HTML5Shiv js for IE8 and below
	wp_enqueue_script('html5shiv', get_template_directory_uri() . '/js/html5shiv/html5shiv' . $suffix . '.js', false);
	wp_script_add_data('html5shiv', 'conditional', 'lt IE 9');
}

add_action('wp_enqueue_scripts', 'tenocation_scripts');

/**
 * Enqueue scripts and styles in the customizer
 */
function tenocation_customizer_scripts() {
	// adding the function to load the minified version if SCRIPT_DEFUG is disable
	$suffix = ( defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style('tenocation-customizer-layout-option-css', get_template_directory_uri() . '/css/tenocation-custom-layout' . $suffix . '.css');
	wp_enqueue_script('tenocation-customizer-layout-option', get_template_directory_uri() . '/js/tenocation-custom-layout' . $suffix . '.js', false, false, true);
}

add_action('customize_controls_enqueue_scripts', 'tenocation_customizer_scripts');

/**
 * Enqueue scripts for use in media upload in widgets
 */
function tenocation_widgets_scripts($hook) {
	// adding the function to load the minified version if SCRIPT_DEFUG is disable
	$suffix = ( defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ) ? '' : '.min';
	if ($hook == 'widgets.php' || $hook == 'customize.php') {
		// image uploader enqueue
		wp_enqueue_media();
		wp_enqueue_script('tenocation-image-uploader', get_template_directory_uri() . '/js/tenocation-image-uploader' . $suffix . '.js', false, false, true);
	}
}

add_action('admin_enqueue_scripts', 'tenocation_widgets_scripts');

/**

* Add a pingback url auto-discovery header for singularly identifiable articles.

*/

function tenocation_pingback_header() {

    if ( is_singular() && pings_open() ) {

        printf( '<link rel="pingback" href="%s">' . "\n", esc_url(get_bloginfo( 'pingback_url' ) ) );

    }

}

add_action( 'wp_head', 'tenocation_pingback_header' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Add the custom meta box for the single post/page layout option
 */
require get_template_directory() . '/inc/meta-boxes.php';

/**
 * Add the required custom widgets
 */
require get_template_directory() . '/inc/widgets.php';