<?php
/**
 * The template for displaying author pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Tenocation
 */
get_header();
?>

<?php do_action('tenocation_before_body_content'); ?>

<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">

		<?php if (have_posts()) : ?>

			<header class="page-header">
				<?php
				echo '<h1 class="page-title"><span>' . sprintf(esc_html__('Author: %s', 'tenocation'), esc_html(get_the_author())) . '</span></h1>';
				tenocation_author_bio();
				?>
			</header><!-- .page-header -->

			<?php
			echo '<div class="grid">';
			/* Start the Loop */
			while (have_posts()) : the_post();

				/*
				 * Include the Post-Format-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
				 */
				get_template_part('template-parts/content', get_post_format());

			endwhile;
			echo '</div>';

			the_posts_pagination();

		else :

			get_template_part('template-parts/content', 'none');

		endif;
		?>

	</main><!-- #main -->
</div><!-- #primary -->

<?php tenocation_sidebar_select(); ?>

<?php do_action('tenocation_after_body_content'); ?>

<?php get_footer(); ?>
