<?php

    /**
     *  We strongly recommend you do not edit this file or any other files.
     *  To customize your theme please use a child theme otherwise, at the next update,
     *  you will lose all your customizations.
     */


    /////   LOAD CLASSES AND METHODS    /////

    // load additional methods ( functions & filters )
    include_once get_template_directory() . '/lib/methods.php';

    /**
     *  Register auto load classes.
     *  load from /tempo/lib/
     */
	function tempo_autoload_lib( $class_name )
    {
	    if( preg_match( "/^tempo_/", $class_name ) ){

	        $class_file = str_replace( '_', '-', str_replace( 'tempo_' , '' , $class_name ) );
	        $class_path  = get_template_directory() . '/lib/tempo.' . $class_file . '.class.php';

	        if( is_file( $class_path ) ){
	            include_once  $class_path;
	        }
	    }
	}

	spl_autoload_register( 'tempo_autoload_lib' );


    {   /////   ADDITIONAL FUNCTIONS    /////

        /**
         *  Generate SubMenu Items
         */
        function tempo_submenu( $id )
        {
            global $tempo_curr_ancestor;

            $pages = get_posts( array(
                'post_type'     => 'page',
                'order'         => 'ASC',
                'post_parent'   => $id
            ) );

            $rett = '';

            if( !empty( $pages ) ){

                $rett = '<ul class="sub-menu">';

                foreach( $pages as $p => $item ){

                    $classes = '';

                    if( is_page( $item -> ID ) ){
                        $classes = 'current-menu-item';
                        $tempo_curr_ancestor = true;
                    }

                    $submenu = tempo_submenu( $item -> ID );

                    if( !empty( $submenu ) ){
                        $classes .= ' menu-item-has-children';

                        if( $tempo_curr_ancestor  ){
                            $classes .= ' current-menu-ancestor';
                        }
                    }

                    $rett .= '<li class="menu-item ' . esc_attr( $classes ) . '">';
                    $rett .= '<a href="' . esc_url( get_permalink( $item ) ) . '" title="' . esc_attr( get_the_title( $item ) ) . '">' . get_the_title( $item ) . '</a>';

                    $rett .= $submenu;

                    $rett .= '</li>';

                }

                $rett .= '</ul>';
            }

            return $rett;
        }

        /**
         *  Check if show the header for specific template
         */

        function tempo_has_header()
        {
            $show_header = false;

            if( is_singular() ){
                global $post;

                if( tempo_is_front_page( $post -> ID ) ) {
                    $show_header = tempo_options::get( 'header-front-page' );
                }

                else if( tempo_is_blog_page() ){
                    $show_header = tempo_options::get( 'header-blog-page' );
                }

                else if( is_singular( 'page' ) ){
                    $show_header = tempo_options::get( 'header-single-page' );
                }

                else if( is_singular( 'post' ) ){
                    $show_header = tempo_options::get( 'header-single-post' );
                }

            }

            else if( tempo_is_blog() ){
                $show_header = tempo_options::get( 'header-blog-page' );
            }

            else{
                $show_header = tempo_options::get( 'header-templates' );
            }

            return (bool)apply_filters( 'tempo_has_header', $show_header ) ;
        }
    }



    /////    START THE SETUP   /////

    /**
     *  General Setup Function
     */
    function tempo_setup_theme()
    {
        /**
         *  Load recursive the config files from
         *  tempo/cfgs/
         */

        include_once get_template_directory() . '/cfgs/theme-url.php';

        include_once get_template_directory() . '/cfgs/main.php';
        include_once get_template_directory() . '/cfgs/icons/social.php';
        include_once get_template_directory() . '/cfgs/icons/fontello.php';

        /**
         *  you can use this action hook to preload
         *  your config files from child theme or plugin
         */

        do_action( 'tempo_preload_cfgs' );


        include_once get_template_directory() . '/cfgs/menus/header.php';

        include_once get_template_directory() . '/cfgs/pages/appearance/faq.php';

        include_once get_template_directory() . '/cfgs/pages/customize/background-image.php';
        include_once get_template_directory() . '/cfgs/pages/customize/colors.php';
        include_once get_template_directory() . '/cfgs/pages/customize/header-image.php';
        include_once get_template_directory() . '/cfgs/pages/customize/site-identity.php';
        include_once get_template_directory() . '/cfgs/pages/customize/tempo.additional.php';
        include_once get_template_directory() . '/cfgs/pages/customize/tempo.blog.php';
        include_once get_template_directory() . '/cfgs/pages/customize/tempo.breadcrumbs.php';
        include_once get_template_directory() . '/cfgs/pages/customize/tempo.header.php';
        include_once get_template_directory() . '/cfgs/pages/customize/tempo.menu.php';
        include_once get_template_directory() . '/cfgs/pages/customize/tempo.others.php';
        include_once get_template_directory() . '/cfgs/pages/customize/tempo.post.php';
        include_once get_template_directory() . '/cfgs/pages/customize/tempo.social.php';

        /**
         *  you can use this action hook to load
         *  your config files from child theme or plugin
         */

        do_action( 'tempo_load_cfgs' );

        /**
         *  you can use this filter hook to mix
         *  child config options with theme config options
         *  config options are used to validate settings and customize ( on tempo_options::get( ' ... ' ) )
         */

        $options    = apply_filters( 'tempo_merge_options', (array)tempo_cfgs::get( 'options' ), null );

        /**
         *  you can use this filter hook to mix
         *  child config settings with theme config settings
         */

        $settings   = apply_filters( 'tempo_merge_settings', (array)tempo_cfgs::get( 'settings' ), null );

        /**
         *  you can use this filter hook to mix
         *  child theme or plugin config settings with theme config settings
         */

        $customize  = apply_filters( 'tempo_merge_customize', (array)tempo_cfgs::get( 'customize' ), null );


        /**
         *  Get config Options from settings and customize
         */

        $options    = tempo_cfgs::merge( $options, tempo_cfgs::optimize( $settings ) );
        $options    = tempo_cfgs::merge( $options, tempo_cfgs::optimize( $customize ) );


        /**
         *  Update config Options
         */

        tempo_cfgs::set( 'options', $options );


        /**
         * Register Admin Pages from config settings
         */

        if( !empty( $settings ) ){
            foreach( $settings as $item => $pages ){
                tempo_html::domain( $item, $pages );
            }
        }


        /**
         *  WordPress API Theme Support
         */

        global $content_width;

        $tempo_content_width = apply_filters( 'tempo_content_width', 750 );

        if( empty( $content_width ) )
            $content_width = $tempo_content_width;

        add_theme_support( 'content-width', absint( $content_width ) ) ;
        add_theme_support( 'automatic-feed-links' );
        add_theme_support( 'post-thumbnails' );
        add_theme_support( 'title-tag' );


        /**
         *  Custom Background Image
         */

        $custom_background = apply_filters( 'tempo_custom_background', (array)tempo_cfgs::get( 'custom-background' ), null );

        add_theme_support( 'custom-background', $custom_background );


        /**
         *  Custom Header Image
         */

        $custom_header = apply_filters( 'tempo_custom_header', (array)tempo_cfgs::get( 'custom-header' ), null );

        add_theme_support( 'custom-header', $custom_header );


        /**
         *  Custom Logo
         */

        $custom_logo = apply_filters( 'tempo_custom_logo', (array)tempo_cfgs::get( 'custom-logo' ), null );

        add_theme_support( 'custom-logo', $custom_logo );


        /**
         *  Custom Image Size
         */

        $images_size = apply_filters( 'tempo_merge_images_size', (array)tempo_cfgs::get( 'images-size' ), null );

        foreach( $images_size as $id => $image_size ){

            if( !(isset( $image_size[ 'width' ] ) && absint( $image_size[ 'width' ] ) > 0) )
                continue;

            if( !(isset( $image_size[ 'height' ] ) && absint( $image_size[ 'height' ] ) > 0) )
                continue;

            $width  = $image_size[ 'width' ];
            $height = $image_size[ 'height' ];
            $crop   = isset( $image_size[ 'crop' ] ) && (bool)$image_size[ 'crop' ];

            //deb::e( array( esc_attr( $id ) , absint( $width ) , absint( $height ), (bool)$crop ) );

            // add custom image size
            add_image_size( esc_attr( $id ) , absint( $width ) , absint( $height ), (bool)$crop );
        }

        set_post_thumbnail_size( 1170, 660 );

        /**
         *  Internationalizations and Localization
         */

        load_theme_textdomain( 'tempo' , get_template_directory() . '/languages' );

        /**
         *  Additional Theme Support
         */

        $additional_theme_support = apply_filters( 'tempo_merge_additional_theme_support', (array)tempo_cfgs::get( 'additional-theme-support' ), null );

        foreach( $additional_theme_support as $support_key => $support_value ){
            if( !empty( $support_value ) ){
                add_theme_support( $support_key, $support_value );
            }

            else{
                add_theme_support( $support_key );
            }
        }
    }

    add_action( 'after_setup_theme', 'tempo_setup_theme' );


    /**
     *  Register WP Customize from config settings
     */

    add_action( 'customize_register', array( 'tempo_html', 'customize' ) );

    /**
     *  Customize Scripts
     *  Customize Preview
     *  Customize Panel
     */

    add_action( 'customize_preview_init', array( 'tempo_scripts', 'customize_preview' ) );
    add_action( 'customize_controls_print_footer_scripts', array( 'tempo_scripts', 'customize_panel' ) );



    /**
     *  Register Menus
     */

    function tempo_register_menus()
    {
        $cfgs = apply_filters( 'tempo_register_menus', (array)tempo_cfgs::get( 'menus' ) );

        if( !empty( $cfgs ) ){
            register_nav_menus( $cfgs );
        }
    }

    add_action( 'init', 'tempo_register_menus' );

    /**
     *  Register Sidebars
     */

    function tempo_register_sidebars()
    {
        $cfgs = apply_filters( 'tempo_merge_sidebars', (array)tempo_cfgs::get( 'sidebars' ) );

        if( !empty( $cfgs ) ){
            foreach( $cfgs as $sides => $sidebars ){
                foreach( $sidebars as $id => $sidebar ){
                    register_sidebar( $sidebar );
                }
            }
        }
    }

    add_action( 'widgets_init', 'tempo_register_sidebars' );



    /**
     *  Enqueue Scripts
     */

    add_action( 'admin_enqueue_scripts', array( 'tempo_scripts', 'admin' ) );
    add_action( 'wp_enqueue_scripts', array( 'tempo_scripts', 'frontend' ), 0 );

    /**
     *  Adding Custom CSS generated with WP Customize
     */

    function tempo_setup_head()
    {
        tempo_get_template_part( 'templates/head/ie' );
        tempo_get_template_part( 'templates/head/style' );
        tempo_get_template_part( 'templates/head/style-child' );
        tempo_get_template_part( 'templates/head/style-pro' );
        tempo_get_template_part( 'templates/head/style-child-common' );
        tempo_get_template_part( 'templates/head/style-child-pro' );
    }

    add_action( 'wp_head', 'tempo_setup_head' );


    /**
     *  Apply Custom Style to shortcode [gallery/]
     *  this feature overwrite just the gallery html content
     */

    add_filter( 'post_gallery', array( 'tempo_gallery',  'shortcode' ), 10, 2 );


    // HOOKS
    include_once get_template_directory() . '/lib/hooks/images.php';
    include_once get_template_directory() . '/lib/hooks/header.php';
    include_once get_template_directory() . '/lib/hooks/fonts.php';

    /**
     *  Custom RSS Feed
     */

    function tempo_rss_thumbnail( $content )
    {
        global $post;

        if ( has_post_thumbnail( $post -> ID ) ){
            $attr       = array( 'style' => 'float:left; margin:0 15px 15px 0;' );
            $content    = '' . get_the_post_thumbnail( $post, 'tempo-classic' , $attr ) . '' . $content;
        }

        return $content;
    }

    add_filter( 'the_excerpt_rss',  'tempo_rss_thumbnail' );
    add_filter( 'the_content_feed', 'tempo_rss_thumbnail' );



    /////   END OF SETUP    /////



    /**
     *  We strongly recommend you do not edit this file or any other files.
     *  To customize your theme please use a child theme otherwise, at the next update,
     *  you will lose all your customizations.
     */
?>
