<?php
/**
 * Tech Startup : Block Patterns
 *
 * @package  Tech Startup 
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'tech-startup',
		array( 'label' => __( ' Tech Startup ', 'tech-startup' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'tech-startup/banner-section',
		array(
			'title'      => __( 'Banner Section', 'tech-startup' ),
			'categories' => array( 'tech-startup' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . get_theme_file_uri() . "/theme-block-pattern/images/banner.png\",\"id\":118,\"dimRatio\":0,\"minHeight\":550,\"isDark\":false,\"align\":\"full\",\"className\":\"tech-banner-section\"} -->\n<div class=\"wp-block-cover alignfull is-light tech-banner-section\" style=\"min-height:550px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-118\" alt=\"\" src=\"" . get_theme_file_uri() . "/theme-block-pattern/images/banner.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":1,\"style\":{\"typography\":{\"fontSize\":\"40px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"textColor\":\"white\"} -->\n<h1 class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:40px;font-style:normal;font-weight:700\">LOREM IPSUM DOLOR SIT AMET</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"15px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:15px\">Lorem ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"style\":{\"color\":{\"background\":\"var(--primary-color)\"},\"border\":{\"radius\":\"25px\"},\"typography\":{\"fontSize\":\"12px\"}},\"className\":\"banner-btn\"} -->\n<div class=\"wp-block-button has-custom-font-size banner-btn\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-black-color has-text-color has-background\" style=\"border-radius:25px;background-color:var(--primary-color)\">READ MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'tech-startup/service-section',
		array(
			'title'      => __( 'Service section', 'tech-startup' ),
			'categories' => array( 'tech-startup' ),
			'content'    => "<!-- wp:group {\"className\":\"tech-service-section mt-md-4 mt-lg-5 mt-3\"} -->\n<div class=\"wp-block-group tech-service-section mt-md-4 mt-lg-5 mt-3\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"32px\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"},\"color\":{\"text\":\"#262626\"}}} -->\n<h2 class=\"has-text-align-center has-text-color\" style=\"color:#262626;font-size:32px;font-style:normal;font-weight:600\">What We Provide</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"backgroundColor\":\"white\"} -->\n<div class=\"wp-block-columns has-white-background-color has-background\"><!-- wp:column {\"backgroundColor\":\"white\",\"className\":\"service-box p-3\"} -->\n<div class=\"wp-block-column service-box p-3 has-white-background-color has-background\"><!-- wp:image {\"id\":821,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"mb-0 mx-md-2\"} -->\n<figure class=\"wp-block-image size-full mb-0 mx-md-2\"><img src=\"" . get_theme_file_uri() . "/theme-block-pattern/images/service-image1.png\" alt=\"\" class=\"wp-image-821\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"},\"color\":{\"text\":\"#262626\"}}} -->\n<h3 class=\"has-text-align-center has-text-color\" style=\"color:#262626;font-size:16px;font-style:normal;font-weight:600\">Advance Startup Service 01</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"14px\"},\"color\":{\"text\":\"#717171\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#717171;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"style\":{\"typography\":{\"fontSize\":\"12px\"},\"border\":{\"radius\":\"25px\"},\"color\":{\"background\":\"var(--primary-color)\"}},\"className\":\"service-btn\"} -->\n<div class=\"wp-block-button has-custom-font-size service-btn\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-black-color has-text-color has-background\" style=\"border-radius:25px;background-color:var(--primary-color)\">VIEW DETAILS</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"service-box p-3\"} -->\n<div class=\"wp-block-column service-box p-3\"><!-- wp:image {\"id\":822,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"mb-0 mx-md-2\"} -->\n<figure class=\"wp-block-image size-full mb-0 mx-md-2\"><img src=\"" . get_theme_file_uri() . "/theme-block-pattern/images/service-image2.png\" alt=\"\" class=\"wp-image-822\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"},\"color\":{\"text\":\"#262626\"}}} -->\n<h3 class=\"has-text-align-center has-text-color\" style=\"color:#262626;font-size:16px;font-style:normal;font-weight:600\">Advance Startup Service 02</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"14px\"},\"color\":{\"text\":\"#717171\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#717171;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"style\":{\"typography\":{\"fontSize\":\"12px\"},\"border\":{\"radius\":\"25px\"},\"color\":{\"background\":\"var(--primary-color)\"}},\"className\":\"service-btn\"} -->\n<div class=\"wp-block-button has-custom-font-size service-btn\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-black-color has-text-color has-background\" style=\"border-radius:25px;background-color:var(--primary-color)\">VIEW DETAILS</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"backgroundColor\":\"white\",\"className\":\"service-box p-3\"} -->\n<div class=\"wp-block-column service-box p-3 has-white-background-color has-background\"><!-- wp:image {\"id\":823,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"mb-0 mx-md-2\"} -->\n<figure class=\"wp-block-image size-full mb-0 mx-md-2\"><img src=\"" . get_theme_file_uri() . "/theme-block-pattern/images/service-image3.png\" alt=\"\" class=\"wp-image-823\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"16px\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"},\"color\":{\"text\":\"#262626\"}}} -->\n<h3 class=\"has-text-align-center has-text-color\" style=\"color:#262626;font-size:16px;font-style:normal;font-weight:600\">Advance Startup Service 03</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"14px\"},\"color\":{\"text\":\"#717171\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#717171;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"black\",\"style\":{\"typography\":{\"fontSize\":\"12px\"},\"border\":{\"radius\":\"25px\"},\"color\":{\"background\":\"var(--primary-color)\"}},\"className\":\"service-btn\"} -->\n<div class=\"wp-block-button has-custom-font-size service-btn\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-black-color has-text-color has-background\" style=\"border-radius:25px;background-color:var(--primary-color)\">VIEW DETAILS</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->",
		)
	);	
}