<div class="theme-import">
	<?php 
        // Check if the demo import has been completed
        $tech_startup_demo_import_completed = get_option('tech_startup_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($tech_startup_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'tech-startup') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '"  class= "run-import view-site" target="_blank">' . esc_html__('VIEW SITE', 'tech-startup') . '</a></span>';
        }

    if (isset($_POST['submit'])) {

    // --- Menu ---
    $tech_startup_primary_menu_name = 'Main Menu';
    $tech_startup_primary_menu_location = 'primary';
    $tech_startup_primary_menu_exists = wp_get_nav_menu_object($tech_startup_primary_menu_name);

    if (!$tech_startup_primary_menu_exists) {
        // Create the left menu
        $tech_startup_primary_menu_id = wp_create_nav_menu($tech_startup_primary_menu_name);

        // Create and assign the Home page
        $tech_startup_home_page_id = wp_insert_post(array(
            'post_type'     => 'page',
            'post_title'    => 'Home',
            'post_content'  => '',
            'post_status'   => 'publish',
            'post_author'   => 1,
            'post_name'     => 'home'
        ));
        // Assign template and set as front page
        add_post_meta($tech_startup_home_page_id, '_wp_page_template', 'page-template/custom-front-page.php');
        update_option('page_on_front', $tech_startup_home_page_id);
        update_option('show_on_front', 'page');

        // Add Home page to the left menu
        wp_update_nav_menu_item($tech_startup_primary_menu_id, 0, array(
            'menu-item-title'     => __('Home', 'tech-startup'),
            'menu-item-classes'   => 'home',
            'menu-item-url'       => home_url('/'),
            'menu-item-status'    => 'publish',
            'menu-item-object-id' => $tech_startup_home_page_id,
            'menu-item-object'    => 'page',
            'menu-item-type'      => 'post_type',
        ));

        // Create and assign the About Us page
        $tech_startup_about_us_page_id = wp_insert_post(array(
            'post_type'     => 'page',
            'post_title'    => 'About Us',
            'post_content'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.',
            'post_status'   => 'publish',
            'post_author'   => 1,
            'post_name'     => 'about-us'
        ));

        // Add About Us page to the left menu
        wp_update_nav_menu_item($tech_startup_primary_menu_id, 0, array(
            'menu-item-title'     => __('About Us', 'tech-startup'),
            'menu-item-classes'   => 'about-us',
            'menu-item-url'       => home_url('/about-us/'),
            'menu-item-status'    => 'publish',
            'menu-item-object-id' => $tech_startup_about_us_page_id,
            'menu-item-object'    => 'page',
            'menu-item-type'      => 'post_type',
        ));

        // Assign left menu to its location
        $tech_startup_locations = get_theme_mod('nav_menu_locations', array());
        $tech_startup_locations[$tech_startup_primary_menu_location] = $tech_startup_primary_menu_id;
        set_theme_mod('nav_menu_locations', $tech_startup_locations);
    }  

    // Set the demo import completion flag
    update_option('tech_startup_demo_import_completed', true);

    // Display success message and "View Site" button
    echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'tech-startup') . '</p>';
    echo '<span><a href="' . esc_url(home_url()) . '" class="view-btn" target="_blank">' . esc_html__('VIEW SITE', 'tech-startup') . '</a></span>';

    //end

    // Topbar Section
    set_theme_mod( 'tech_startup_tob_bar_info_text', 'Cutting Edge Solutions For Start-up Agency' );
    set_theme_mod( 'tech_startup_location_text', 'ADDRESS' );
    set_theme_mod( 'tech_startup_location', '198, Street West, 21 Street' );
    set_theme_mod( 'tech_startup_email_text', 'EMAIL' );
    set_theme_mod( 'advance_startup_mail1', 'support@example.com' );
    set_theme_mod( 'tech_startup_phone_text', 'PHONE' );
    set_theme_mod( 'advance_startup_phone1', '+00 123-456-7890' );
    set_theme_mod( 'advance_startup_top_button_text', "LET'S TALK" );

    // Social Icons
    set_theme_mod( 'advance_startup_facebook_url', '#' );
    set_theme_mod( 'advance_startup_twitter_url', '#' );
    set_theme_mod( 'advance_startup_youtube_url', '#' );
    set_theme_mod( 'advance_startup_linkedin_url', '#' );

    // Slider
    for($advance_startup_i=1;$advance_startup_i<=4;$advance_startup_i++){
       $advance_startup_slider_title = 'Lorem Ipsum Dolor Sit Amet';
       $advance_startup_slider_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.';
          // Create post object
       $advance_startup_my_post = array(
       'post_title'    => wp_strip_all_tags( $advance_startup_slider_title ),
       'post_content'  => $advance_startup_slider_content,
       'post_status'   => 'publish',
       'post_type'     => 'page',
       );

       // Insert the post into the database
       $advance_startup_post_id = wp_insert_post( $advance_startup_my_post );

       if ($advance_startup_post_id) {
         // Set the theme mod for the slider page
         set_theme_mod('advance_startup_slider_page' . $advance_startup_i, $advance_startup_post_id);

          $advance_startup_image_url = get_template_directory_uri().'/images/slider'.$advance_startup_i.'.png';

        $advance_startup_image_id = media_sideload_image($advance_startup_image_url, $advance_startup_post_id, null, 'id');

            if (!is_wp_error($advance_startup_image_id)) {
                // Set the downloaded image as the post's featured image
                set_post_thumbnail($advance_startup_post_id, $advance_startup_image_id);
            }
        }
    }

    // We Provide Section
    set_theme_mod( 'advance_startup_title', 'What We Provide' );
    set_theme_mod( 'tech_startup_small_title', 'Advance Startup Services' );

    // Post Category
    set_theme_mod( 'advance_startup_we_provide_category', 'category1' );

    // Define post category names and post titles
    $advance_startup_category_names = array('category1', 'category2', 'category3');
    $advance_startup_title_array = array(
        array("Advance Startup Service 01", "Advance Startup Service 02", "Advance Startup Service 03"),
        array("Advance Startup Service 01", "Advance Startup Service 02", "Advance Startup Service 03"),
        array("Advance Startup Service 01", "Advance Startup Service 02", "Advance Startup Service 03")
    );

        foreach ($advance_startup_category_names as $advance_startup_index => $advance_startup_category_name) {
            // Create or retrieve the post category term ID
            $advance_startup_term = term_exists($advance_startup_category_name, 'category');
            if ($advance_startup_term === 0 || $advance_startup_term === null) {
                // If the term does not exist, create it
                $advance_startup_term = wp_insert_term($advance_startup_category_name, 'category');
            }
            if (is_wp_error($advance_startup_term)) {
                error_log('Error creating category: ' . $advance_startup_term->get_error_message());
                continue; // Skip to the next iteration if category creation fails
            }

            for ($advance_startup_i = 0; $advance_startup_i < 3; $advance_startup_i++) {
                // Create post content
                $advance_startup_title = $advance_startup_title_array[$advance_startup_index][$advance_startup_i];
                $advance_startup_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever.';

                // Create post post object
                $advance_startup_my_post = array(
                    'post_title'    => wp_strip_all_tags($advance_startup_title),
                    'post_content'  => $advance_startup_content,
                    'post_status'   => 'publish',
                    'post_type'     => 'post', // Post type set to 'post'
                );

                // Insert the post into the database
                $advance_startup_post_id = wp_insert_post($advance_startup_my_post);

                if (is_wp_error($advance_startup_post_id)) {
                    error_log('Error creating post: ' . $advance_startup_post_id->get_error_message());
                    continue; // Skip to the next post if creation fails
                }

                // Assign the category to the post
                wp_set_post_categories($advance_startup_post_id, array((int)$advance_startup_term['term_id']));

                // Handle the featured image using media_sideload_image
                $advance_startup_image_url =  get_theme_file_uri() . '/theme-block-pattern/images/service-image' . ($advance_startup_i + 1) . '.png';
                $advance_startup_image_id = media_sideload_image($advance_startup_image_url, $advance_startup_post_id, null, 'id');

                if (is_wp_error($advance_startup_image_id)) {
                    error_log('Error downloading image: ' . $advance_startup_image_id->get_error_message());
                    continue; // Skip to the next post if image download fails
                }
                // Assign featured image to post
                set_post_thumbnail($advance_startup_post_id, $advance_startup_image_id);
            }
        }
    }
    ?>

	 <p class="note"><?php esc_html_e( 'Please Note: If your website is live and already contains data, we recommend creating a backup first. Running this importer will replace your current settings with the custom values from the demo.', 'tech-startup' ); ?></p>
        <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=tech_startup_guide" method="POST" onsubmit="return validate(this);">
        <?php if (!get_option('tech_startup_demo_import_completed')) : ?>
            <button type="submit" name="submit" class="run-import">
                    <?php esc_html_e('Run Importer','tech-startup'); ?>
                    <span id="spinner" style="display: none;">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/spinner.gif" alt="Loading..." style="width:34px; height:34px; vertical-align: middle;" />
                    </span>
            </button>
        <?php endif; ?>
        </form>
        <script type="text/javascript">
            function validate(valid) {
                if(confirm("Do you really want to import the theme demo content?")){
                    document.getElementById('spinner').style.display = 'inline-block';
                }
                else {
                    return false;
                }
            }
        </script>
    
     
</div>
