<?php
//about theme info
add_action( 'admin_menu', 'tech_startup_gettingstarted' );
function tech_startup_gettingstarted() {    	
	add_theme_page( esc_html__('Theme Demo Content', 'tech-startup'), esc_html__('Theme Demo Content', 'tech-startup'), 'edit_theme_options', 'tech_startup_guide', 'tech_startup_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function tech_startup_admin_theme_style() {
   wp_enqueue_style('tech-startup-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/admin/admin.css');
   wp_enqueue_script('tabs', esc_url(get_theme_file_uri()) . '/inc/admin/js/tab.js');

	// Admin notice code START
	wp_register_script('tech-startup-notice', esc_url(get_theme_file_uri()) . '/inc/admin/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('tech-startup-notice');
	// Admin notice code END

}
add_action('admin_enqueue_scripts', 'tech_startup_admin_theme_style');

//guidline for about theme
function tech_startup_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'tech-startup' );
?>

<div class="wrapper-info">  
	<div id="tc-header">
		<div class="tc-container main-header">
			<a class="tc-logo">
				<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/admin/images/logo.png" alt="" />
			</a>
			<span class="tc-header-action">
			<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customize', 'tech-startup'); ?></a>
			<a href="<?php echo esc_url( TECH_STARTUP_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'tech-startup' ); ?></a>
				<a href="<?php echo esc_url( 'https://www.themescaliber.com/products/tech-startup-wordpress-theme'); ?>" target="_blank"> <?php esc_html_e( 'Get Premium', 'tech-startup' ); ?></a>
			<a href="<?php echo esc_url( 'https://www.themescaliber.com/products/wordpress-theme-bundle' ); ?>" class="bundle_btn" target="_blank"> <?php esc_html_e( 'Bundle of 220+ Themes at $99', 'tech-startup' ); ?></a>
			</span>
		</div>
	</div>
	<div class="tc-container tab-sec">
		<div class="tc-tabs">
			<ul>
				<li class="tablinks home active" onclick="tech_startup_openCity(event, 'tc_demo')">
					<a href="#">
						<?php esc_html_e( 'Theme Demo Import', 'tech-startup' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="tech_startup_openCity(event, 'tc_index')">
					<a href="#">
						<?php esc_html_e( 'Free Theme Information', 'tech-startup' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="tech_startup_openCity(event, 'tc_pro')">
					<a href="#">
						<?php esc_html_e( 'Premium Theme Information', 'tech-startup' ); ?>
					</a>
				</li>
				<li class="tablinks" onclick="tech_startup_openCity(event, 'tc_create')">
					<a href="#">
						<?php esc_html_e( 'Theme Support', 'tech-startup' ); ?>
					</a>
				</li>
			</ul>
		</div><!-- END .tc-tabs -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div  id="tc_demo" class="tabcontent">
				<h2><?php esc_html_e( 'Welcome to Tech Startup', 'tech-startup' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
				<hr>
				<div class="demo">
					<h4><?php esc_html_e( 'Click the "Run Importer" button below to load demo content for Tech Startup', 'tech-startup' ); ?></h4>
					<?php /* Demo Import */ require get_theme_file_path( '/inc/admin/demo-import.php' );?>
				</div>
			</div><!-- END .tc-section -->
		</div>
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div  id="tc_index" class="tabcontent">
				<h2><?php esc_html_e( 'Welcome to Tech Startup Theme', 'tech-startup' ); ?> <span class="version">Version: <?php echo esc_html($theme['Version']);?></span></h2>
				<hr>
				<div class="info-link">
					<a href="<?php echo esc_url( TECH_STARTUP_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'tech-startup' ); ?></a>
					<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'tech-startup'); ?></a>
					<a class="get-pro" href="<?php echo esc_url( TECH_STARTUP_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Get Pro', 'tech-startup'); ?></a>
				</div>
				<div class="col-tc-6">
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/admin/images/screenshot.png" alt="" />
				</div>
				<div class="col-tc-6">
					<P><?php esc_html_e( 'Tech Startup is a versatile and professional theme ideal for startups and agencies in the technical business domain. Perfect for IT and tech startups, corporates, web development agencies, tech bloggers, SaaS providers, fintech firms, AI-powered solutions, blockchain platforms, e-commerce startups, cloud service providers, IT solutions companies, cybersecurity consultants, data analytics experts, mobile app developers, edtech platforms, software development agencies, tech consulting firms, and digital marketing businesses, the theme features an innovative, minimalist design that highlights content and draws attention to key messages. Built on the robust Bootstrap framework, it delivers a responsive, mobile-friendly, and user-centric experience across desktops, laptops, tablets, and smartphones. SEO-friendly and schema-ready code ensures higher search engine rankings, while highly optimized code guarantees fast performance and quick page loading. Interactive Call to Action (CTA) buttons, smooth CSS animations, and integrated social media icons enhance engagement, while full compatibility with WooCommerce for online selling, Contact Form 7 for forms, Mailchimp for newsletters, and Yoast SEO for content optimization make it a complete solution. With numerous personalization options and an intuitive customizer, you can tailor the layout and give your site a unique identity.', 'tech-startup' ); ?></P>
				</div>
			</div>
		</div><!-- END .tc-section -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div id="tc_pro" class="tabcontent">
				<h3><?php esc_html_e( 'Tech Startup Theme Information', 'tech-startup' ); ?></h3>
				<hr>
				<div class="info-link-pro">
					<a href="<?php echo esc_url( TECH_STARTUP_BUY_NOW ); ?>" target="_blank"> <?php esc_html_e( 'Buy Now', 'tech-startup' ); ?></a>
					<a href="<?php echo esc_url( TECH_STARTUP_LIVE_DEMO ); ?>" target="_blank"> <?php esc_html_e( 'Live Demo', 'tech-startup' ); ?></a>
					<a href="<?php echo esc_url( TECH_STARTUP_PRO_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Pro Documentation', 'tech-startup' ); ?></a>
				</div>
				<div class="pro-image">
					<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/admin/images/responsiveimg.jpg" alt="" />
				</div>
				<div class="col-pro-5">
					<h4><?php esc_html_e( 'seo agency lite Pro Theme', 'tech-startup' ); ?></h4>
					<P><?php esc_html_e( 'For any technical and analytical company or startup, this Tech Startup WordPress Theme has an ideal layout. Being packed with original and highly responsive templates, it serves as a complete solution for any kind of technical business website. Speaking about its flexibility and versatility, its responsive design makes your website adjust to every screen with perfection no matter what device the audience is using for viewing it. There is an ample amount of demo data included to get you started without wasting any time. If you think the demo is not up to the mark, modify the existing template using the theme customizer options. As a business owner, you know your requirements better than any other person. So take control in your hand and use the drag and drop page builder tool of this Tech Startup WordPress Theme to create your own customized pages and get the desired look for your website.', 'tech-startup' ); ?>
					</P>		
				</div>
				<div class="col-pro-6">				
					<h4><?php esc_html_e( 'Theme Features', 'tech-startup' ); ?></h4>
					<ul>
						<li><?php esc_html_e( 'Theme Options using Customizer API', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Responsive design', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Favicon, Logo, title and tagline customization', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Advanced Color options', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( '100+ Font Family Options', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Background Image Option', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Simple Menu Option', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Additional section for products', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Enable-Disable options on All sections', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Home Page setting for different sections', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Advance Slider with unlimited slides', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Partner Section', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Promotional Banner Section for Products', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Seperate Newsletter Section', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Text and call to action button for each slides', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Pagination option', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Custom CSS option', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Translations Ready', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Custom Backgrounds, Colors, Headers, Logo & Menu', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Customizable Home Page', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Full-Width Template', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Footer Widgets & Editor Style', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Banner & Post Type Plugin Functionality', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Woo Commerce Compatible', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Multiple Inner Page Templates', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Product Sliders', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Testimonial Slider', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Testimonial Posttype', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Testimonial Listing With Shortcode', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Contact page template', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Contact Widget', 'tech-startup' ); ?></li>
						<li><?php esc_html_e( 'Advance Social Media Feature', 'tech-startup' ); ?></li>
					</ul>				
			</div>	
		</div><!-- END .tc-section -->
	</div>

	<div class="tc-container">
		<div class="tc-section">
			<div id="tc_create" class="tabcontent">
				<div class="tab-cont">
					<h4><?php esc_html_e( 'Need Support?', 'tech-startup' ); ?></h4>				
					<div class="info-link-support">
						<P><?php esc_html_e( 'Our team is obliged to help you in every way possible whenever you face any type of difficulties and doubts.', 'tech-startup' ); ?></P>
						<a href="<?php echo esc_url( TECH_STARTUP_SUPPORT ); ?>" target="_blank"> <?php esc_html_e( 'Support Forum', 'tech-startup' ); ?></a>
					</div>
				</div>
				<div class="tab-cont">	
					<h4><?php esc_html_e('Reviews', 'tech-startup'); ?></h4>				
					<div class="info-link-support">
						<P><?php esc_html_e( 'It is commendable to have such a theme inculcated with amazing features and robust functionalities. I feel grateful to recommend this theme to one and all.', 'tech-startup' ); ?></P>
						<a href="<?php echo esc_url( TECH_STARTUP_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'tech-startup'); ?></a>
					</div>
				</div>

				<div class="tc-section large-section">
					<h2>Let‘s customize your website</h2>
					<p>There are many changes you can make to customize your website. Explore customization options and make it unique.</p>
					<div class="tc-buttons">
						<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>" class="tc-btn primary large-button"><?php esc_html_e('Start Customizing', 'tech-startup'); ?></a>
					</div><!-- END .tc-buttons -->
				</div>
			</div>
		</div><!-- END .tc-section -->
	</div>
</div>
<?php } ?>