<?php
/**
 * Theme Functions.
 */

/* Theme Setup */
if ( ! function_exists( 'tech_startup_setup' ) ) :

function tech_startup_setup() {

	$GLOBALS['content_width'] = apply_filters( 'tech_startup_content_width', 640 );

	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-logo', array(
		'height'      => 240,
		'width'       => 240,
		'flex-height' => true,
	) );

	add_theme_support( 'custom-background', array(
		'default-color' => 'f1f1f1'
	) );

	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	add_theme_support('responsive-embeds');
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'css/editor-style.css', advance_startup_font_url() ) );

	// Theme Activation Notice
	global $pagenow;
	
	if (
		is_admin()
		&&
		('themes.php' == $pagenow)
		// &&
		// isset( $_GET['activated'] )
	) {
		add_action('admin_notices', 'tech_startup_activation_notice');
	}
}
endif;
add_action( 'after_setup_theme', 'tech_startup_setup' );

// Dashboard Theme Notification  
function tech_startup_activation_notice() {
		$tech_startup_meta = get_option( 'tech_startup_admin_notice' );

	if (!$tech_startup_meta) {
	echo '<div id="tech-startup-welcome-notice" class="notice is-dismissible advance-startup-notice">';
		echo '<div class="advance-startup-banner">';
			echo '<div class="advance-startup-text">';
				echo '<h2>' . esc_html__( 'Thanks For Installing the "Tech Startup" Theme !', 'tech-startup' ) . '</h2>';
				echo '<p>' . esc_html__( 'We’re excited to help you get started with your new theme! Set up your website quickly and easily by importing our demo content and customizing it to suit your needs.', 'tech-startup' ) . '</p>';
				echo '<div class="advance-startup-buttons">';
					echo '<a href="' . esc_url( admin_url( 'themes.php?page=tech_startup_guide' ) ) . '">' . esc_html__( 'Demo Import', 'tech-startup' ) . '</a>';
					echo '<a href="'. esc_url( 'https://preview.themescaliber.com/doc/free-tech-startup/' ) .'" target=_blank>' . esc_html__( 'Documentation', 'tech-startup' ) . '</a>';
					echo '<a href="'. esc_url( 'https://www.themescaliber.com/products/tech-startup-wordpress-theme' ) .'" target=_blank>' . esc_html__( 'Get Premium', 'tech-startup' ) . '</a>';
					echo '<a class="bundle_btn" href="'. esc_url( 'https://www.themescaliber.com/products/wordpress-theme-bundle' ) .'" target=_blank>' . esc_html__( 'Bundle of 220+ Themes at $99', 'tech-startup' ) . '</a>';
				echo '</div>';
			echo '</div>';
			echo '<div class="advance-startup-image">';
				echo '<img src="' . esc_url(get_theme_file_uri()) . '/images/demo-preview.png">';
			echo '</div>';
		echo '</div>';
    echo '</div>';
}
}



/* Theme Widgets Setup */
function tech_startup_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'tech-startup' ),
		'description'   => __( 'Appears on blog page sidebar', 'tech-startup' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'tech-startup' ),
		'description'   => __( 'Appears on page sidebar', 'tech-startup' ),
		'id'            => 'sidebar-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Third Column Sidebar', 'tech-startup' ),
		'description'   => __( 'Appears on page sidebar', 'tech-startup' ),
		'id'            => 'sidebar-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	//Footer widget areas
	$advance_startup_widget_areas = get_theme_mod('advance_startup_footer_widget_areas', '4');
	for ($i=1; $i<=$advance_startup_widget_areas; $i++) {
		register_sidebar( array(
			'name'          => __( 'Footer Nav ', 'tech-startup' ) . $i,
			'id'            => 'footer-' . $i,
			'description'   => '',
			'before_widget' => '<aside id="%1$s" class="widget %2$s py-3">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title pb-2 mb-3">',
			'after_title'   => '</h3>',
		) );
	}

	register_sidebar( array(
		'name'          => __( 'Shop Page Sidebar', 'tech-startup' ),
		'description'   => __( 'Appears on shop page', 'tech-startup' ),
		'id'            => 'woocommerce_sidebar',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Single Product Page Sidebar', 'tech-startup' ),
		'description'   => __( 'Appears on shop page', 'tech-startup' ),
		'id'            => 'woocommerce-single-sidebar',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'tech_startup_widgets_init' );

add_action( 'wp_enqueue_scripts', 'tech_startup_enqueue_styles' );
function tech_startup_enqueue_styles() {
	$parent_style = 'advance-startup-basic-style'; // Style handle of parent theme.
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'tech-startup-style', get_stylesheet_uri(), array( $parent_style ) );
	wp_enqueue_style( 'tech-startup-block-patterns-style-frontend', get_theme_file_uri('/theme-block-pattern/css/block-pattern-frontend.css') );
	require get_parent_theme_file_path( '/inc/ts-color-pallete.php' );
	wp_add_inline_style( 'tech-startup-style',$advance_startup_custom_css );
	require get_theme_file_path( '/inc/ts-color-pallete.php' );
	wp_add_inline_style( 'tech-startup-style',$advance_startup_custom_css );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

function tech_startup_customize_register() {     
	global $wp_customize;
	
	$wp_customize->remove_setting( 'advance_startup_time' );
	$wp_customize->remove_control( 'advance_startup_time' );

	$wp_customize->remove_setting( 'advance_startup_responsive_sticky_header' );
	$wp_customize->remove_control( 'advance_startup_responsive_sticky_header' );

	$wp_customize->remove_setting( 'advance_startup_sticky_header' );
	$wp_customize->remove_control( 'advance_startup_sticky_header' );

	$wp_customize->remove_setting( 'advance_startup_sticky_header_padding_settings' );
	$wp_customize->remove_control( 'advance_startup_sticky_header_padding_settings' );

	$wp_customize->remove_setting( 'advance_startup_slider_image_overlay_color_first' );
	$wp_customize->remove_setting( 'advance_startup_slider_image_overlay_color_second' );


	$wp_customize->remove_setting( 'advance_startup_breadcrumb_bg_color_first' );
	$wp_customize->remove_setting( 'advance_startup_breadcrumb_bg_color_second' );

	$wp_customize->remove_setting( 'advance_startup_topbar_premium_info' );
	$wp_customize->remove_control( 'advance_startup_topbar_premium_info' );

	$wp_customize->remove_setting( 'advance_startup_header_time_icon' );
	$wp_customize->remove_control( 'advance_startup_header_time_icon' );
	
} 
add_action( 'customize_register', 'tech_startup_customize_register', 11 );

// Customizer Section
function tech_startup_customizer ( $wp_customize ) {

	$wp_customize->add_setting('tech_startup_tob_bar_info_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('tech_startup_tob_bar_info_text',array(
		'label'	=> __('Tob Bar Announcement Text','tech-startup'),
		'section'	=> 'advance_startup_topbar',
		'setting'	=> 'tech_startup_tob_bar_info_text',
		'type'	=> 'text',
	));

	$wp_customize->add_setting('tech_startup_location_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('tech_startup_location_text',array(
		'label'	=> __('Location Text','tech-startup'),
		'section'	=> 'advance_startup_topbar',
		'setting'	=> 'tech_startup_location_text',
		'type'	=> 'text',
	));

	$wp_customize->add_setting('tech_startup_location',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('tech_startup_location',array(
		'label'	=> __('Location','tech-startup'),
		'section'	=> 'advance_startup_topbar',
		'setting'	=> 'tech_startup_location',
		'type'	=> 'text',
	));

	$wp_customize->add_setting('tech_startup_email_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('tech_startup_email_text',array(
		'label'	=> __('Mail Address Text','tech-startup'),
		'section'	=> 'advance_startup_topbar',
		'setting'	=> 'tech_startup_email_text',
		'type'	=> 'text',
	));

	$wp_customize->add_setting('tech_startup_phone_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('tech_startup_phone_text',array(
		'label'	=> __('Phone Number Text','tech-startup'),
		'section'	=> 'advance_startup_topbar',
		'setting'	=> 'tech_startup_phone_text',
		'type'	=> 'text',
	));

	$wp_customize->add_setting('tech_startup_slider_image_overlay_color_first', array(
		'default'           => '#FFE000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tech_startup_slider_image_overlay_color_first', array(
		'label'    => __('Home Page Slider Overlay Color First', 'tech-startup'),
		'section'  => 'advance_startup_slider',
		'description'    => __('It will add the color overlay of the slider. To make it transparent, use the below option.','tech-startup'),
		'settings' => 'tech_startup_slider_image_overlay_color_first',
	)));

	$wp_customize->add_setting('tech_startup_slider_image_overlay_color_second', array(
		'default'           => '#799F0C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tech_startup_slider_image_overlay_color_second', array(
		'label'    => __('Home Page Slider Overlay Color Second', 'tech-startup'),
		'section'  => 'advance_startup_slider',
		'description'    => __('It will add the color overlay of the slider. To make it transparent, use the below option.','tech-startup'),
		'settings' => 'tech_startup_slider_image_overlay_color_second',
	)));

	$wp_customize->add_setting('tech_startup_small_title',array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_text_field',
   	));
   	$wp_customize->add_control('tech_startup_small_title',array(
	    'label' => __('Small Section Title','tech-startup'),
	    'section' => 'advance_startup_category',
	    'type'  => 'text'
   	));

  	$wp_customize->add_setting( 'tech_startup_breadcrumb_bg_color', array(
	    'default' => '#ffd64e',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'tech_startup_breadcrumb_bg_color', array(
  		'label' => __('Breadcrumb Background Color', 'tech-startup'),
	    'section' => 'advance_startup_left_right',
	    'settings' => 'tech_startup_breadcrumb_bg_color',
  	)));

  	$wp_customize->add_setting('tech_startup_breadcrumb_bg_hover_color', array(
		'default'           => '#799F0C',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'tech_startup_breadcrumb_bg_hover_color', array(
		'label'    => __('Breadcrumb Background Hover Color', 'tech-startup'),
		'section'  => 'advance_startup_left_right',
		'settings' => 'tech_startup_breadcrumb_bg_hover_color',
	)));
}
add_action( 'customize_register', 'tech_startup_customizer' );

/**
 * Enqueue block editor style
 */
function tech_startup_block_editor_styles() {
	wp_enqueue_style( 'tech-startup-font', advance_startup_font_url(), array() );
    wp_enqueue_style( 'tech-startup-block-patterns-style-editor', get_theme_file_uri( '/theme-block-pattern/css/block-pattern-editor.css' ), false, '1.0', 'all' );
}
add_action( 'enqueue_block_editor_assets', 'tech_startup_block_editor_styles' );

function tech_startup_links_setup() {
	// Doc Link
	if ( ! defined( 'ADVANCE_STARTUP_PRO_THEME_DOC_LINK' ) ) {
		define( 'ADVANCE_STARTUP_PRO_THEME_DOC_LINK', 'https://preview.themescaliber.com/doc/free-tech-startup/' );
	}

	// Demo Link
	if ( ! defined( 'ADVANCE_STARTUP_PRO_THEME_DEMO_LINK' ) ) {
		define( 'ADVANCE_STARTUP_PRO_THEME_DEMO_LINK', 'https://preview.themescaliber.com/tech-startup-pro/' );
	}

	// Pro Link
	if ( ! defined( 'ADVANCE_STARTUP_PRO_THEME_LINK' ) ) {
		define( 'ADVANCE_STARTUP_PRO_THEME_LINK',__('https://www.themescaliber.com/products/tech-startup-wordpress-theme','tech-startup') );
	}
	if ( ! defined( 'ADVANCE_STARTUP_PRO_THEME_TEXT' ) ) {
		define( 'ADVANCE_STARTUP_PRO_THEME_TEXT', __('Tech Startup Pro Theme','tech-startup') );
	}

	if (!function_exists('tech_startup_credit')) {
		function tech_startup_credit() {
			echo "<a href=".esc_url(TECH_STARTUP_CREDIT)." target='_blank''>".esc_html__('Tech Startup WordPress Theme', 'tech-startup')."</a>";
		}
	}

	define('TECH_STARTUP_BUY_NOW',__('https://www.themescaliber.com/products/tech-startup-wordpress-theme', 'tech-startup'));
	define('TECH_STARTUP_LIVE_DEMO',__('https://preview.themescaliber.com/tech-startup-pro/', 'tech-startup'));
	define('TECH_STARTUP_CONTACT',__('https://wordpress.org/support/theme/tech-startup/', 'tech-startup'));
	define('TECH_STARTUP_FREE_THEME_DOC',__('https://preview.themescaliber.com/doc/free-tech-startup/','tech-startup'));
	define('TECH_STARTUP_PRO_DOC',__('https://preview.themescaliber.com/doc/tech-startup-pro/', 'tech-startup'));
	define('TECH_STARTUP_CREDIT',__('https://www.themescaliber.com/products/tech-startup/', 'tech-startup'));
	define('TECH_STARTUP_SUPPORT',__('https://wordpress.org/support/theme/tech-startup/','tech-startup'));
	define('TECH_STARTUP_REVIEW',__('https://wordpress.org/support/theme/tech-startup/reviews/','tech-startup'));
	/* Admin about theme */
	require get_theme_file_path('/inc/admin/admin.php');

	/* Block Pattern */
	require get_theme_file_path('/theme-block-pattern/theme-block-pattern.php');
}
add_action( 'after_setup_theme', 'tech_startup_links_setup' );

function tech_startup_remove_action() {
      remove_action( 'admin_menu','advance_startup_gettingstarted' );
    remove_action( 'admin_notices','advance_startup_activation_notice' );
}
add_action( 'init', 'tech_startup_remove_action');

/*------------------------------section-pro.php part----------------------------------------*/
require_once( ABSPATH . WPINC . '/class-wp-customize-section.php' );

class Tech_Startup_Customize_Section_Pro extends WP_Customize_Section {

	/**
	 * Outputs the Underscore.js template.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	protected function render_template() { ?>

		<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">
			<h3 class="accordion-section-title">
				{{ data.title }}

				<# if ( data.pro_text && data.pro_url ) { #>
					<a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
				<# } #>
			</h3>
		</li>
	<?php }
}

/*---------------customizer.php part--------------------------*/
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Tech_Startup_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Register custom section types.
		$manager->register_section_type( 'Tech_Startup_Customize_Section_Pro' );

	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */

	public function enqueue_control_scripts() {
		wp_enqueue_style( 'tech_startup-customize-controls', get_stylesheet_directory_uri() . '/css/customize-controls-child.css' );
	}
}

// Doing this customizer thang!
Tech_Startup_Customize::get_instance();

// Admin notice code START
function tech_startup_dismissed_notice() {
	update_option( 'tech_startup_admin_notice', true );
}
add_action( 'wp_ajax_tech_startup_dismissed_notice', 'tech_startup_dismissed_notice' );


//After Switch theme function
add_action('after_switch_theme', 'tech_startup_getstart_setup_options');
function tech_startup_getstart_setup_options () {
    update_option('tech_startup_admin_notice', false );
}
// Admin notice code END


