<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package tdtasko
 * @since tdtasko 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
	<?php do_action( 'tdtasko_before_header' ); ?>
	<header id="masthead" class="site-header" role="banner">
		
		<div class="brand-box">
			<div class="row">
			
  				<div class="two columns push-ten pages-list">
    				<h1><a class="more border-radius-small" href="#"><i class="foundicon-plus"></i></a></h1>
  				</div>
  				
  				<div class="ten columns pull-two">
    				 <h1 class="site-title">
    				 	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a> 
    				 	<span class="seperator">|</span> 
    				 	<span class="site-description"><?php bloginfo( 'description' ); ?></span>
    				 </h1>
  				</div>
  				
			</div>
		</div>

		<nav role="navigation" class="site-navigation main-navigation">
			
			<div id="top-menu" class="row">
				<div class="twelve columns menu-list">
					<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
				</div>
			</div>
			
		</nav><!-- .site-navigation .main-navigation -->
	</header><!-- #masthead .site-header -->

	<div id="main" class="site-main row">
