<?php
/**
 * The template used for displaying image content
 *
 * @package tdtasko
 * @since tdtasko 1.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<h2 class="entry-title"><?php the_title(); ?></h2>

		<div class="entry-meta">
			<?php tdtasko_posted_on(); ?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->
	
	<div class="entry-content">
	
		<?php if ( get_the_post_thumbnail() != ''  ): ?>
		
			<div class="wp-caption">
				<a href="<?php the_permalink() ?>"><?php the_post_thumbnail(); ?></a>
				<div class="wp-caption-text"><?php the_title(); ?></div>
			</div>
			
			<?php if ( is_single() ): ?>
				<?php the_content(); ?>
			<?php endif; ?>
			
		<?php else: ?>
		
			<div class="entry-content">
				<?php the_content(); ?>
			</div>
			
		<?php endif; ?>
	</div><!-- .entry-content -->
	<footer class="entry-meta bottom">
		<?php
			/* translators: used between list items, there is a space after the comma */
			$category_list = get_the_category_list( __( ', ', 'tdtasko' ) );

			/* translators: used between list items, there is a space after the comma */
			$tag_list = get_the_tag_list( '', __( ', ', 'tdtasko' ) );

			if ( ! tdtasko_categorized_blog() ) {
				// This blog only has 1 category so we just need to worry about tags in the meta text
				if ( '' != $tag_list ) {
					$meta_text = __( 'This entry was tagged %2$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'tdtasko' );
				} else {
					$meta_text = __( 'Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'tdtasko' );
				}

			} else {
				// But this blog has loads of categories so we should probably display them here
				if ( '' != $tag_list ) {
					$meta_text = __( 'This entry was posted in %1$s and tagged %2$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'tdtasko' );
				} else {
					$meta_text = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'tdtasko' );
				}

			} // end check for categories on this blog

			printf(
				$meta_text,
				$category_list,
				$tag_list,
				get_permalink(),
				the_title_attribute( 'echo=0' )
			);
		?>

		<?php edit_post_link( __( 'Edit', 'tdtasko' ), '<span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->

</article><!-- #post-<?php the_ID(); ?> -->

<div class="after-post-widget">
	<?php if ( ! dynamic_sidebar( 'sidebar-2' ) ) : ?>
	<?php endif; // end post-after widget area ?>
</div>