<?php
/**
 * The template used for displaying link content
 *
 * @package tdtasko
 * @since tdtasko 1.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="link-entry-content">
		<span class="link-icon"></span>
		<?php 
			$content = get_post_field('post_content', $post->ID);
			echo '<p>' . $content . '</p>';
		?>
	</div>
	
	<footer class="entry-meta bottom">
		<?php
			/* translators: used between list items, there is a space after the comma */
			$category_list = get_the_category_list( __( ', ', 'tdtasko' ) );

			/* translators: used between list items, there is a space after the comma */
			$tag_list = get_the_tag_list( '', __( ', ', 'tdtasko' ) );

			if ( ! tdtasko_categorized_blog() ) {
				// This blog only has 1 category so we just need to worry about tags in the meta text
				if ( '' != $tag_list ) {
					$meta_text = __( 'This entry was tagged %2$s / <a href="%3$s" title="Permalink to %4$s" rel="bookmark">Read More</a>', 'tdtasko' );
				} else {
					$meta_text = __( '<a href="%3$s" title="Permalink to %4$s" rel="bookmark">Read More</a>', 'tdtasko' );
				}

			} else {
				// But this blog has loads of categories so we should probably display them here
				if ( '' != $tag_list ) {
					$meta_text = __( 'This entry was posted in %1$s and tagged %2$s / <a href="%3$s" title="Permalink to %4$s" rel="bookmark">Read More</a>', 'tdtasko' );
				} else {
					$meta_text = __( 'This entry was posted in %1$s / <a href="%3$s" title="Permalink to %4$s" rel="bookmark">Read More</a>', 'tdtasko' );
				}

			} // end check for categories on this blog

			printf(
				$meta_text,
				$category_list,
				$tag_list,
				get_permalink(),
				the_title_attribute( 'echo=0' )
			);
		?>

		<?php edit_post_link( __( 'Edit', 'tdtasko' ), ' / <span class="edit-link">', '</span>' ); ?>
	</footer><!-- .entry-meta -->

</article><!-- #post-<?php the_ID(); ?> -->