<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package tdBlu
 * @since tdBlu 1.0
 */

get_header(); ?>

		<section class="archive-top-title twelve columns">
			<header class="page-header">
				<h3 class="page-title"><?php printf( __( 'Search Results for: %s', 'tdblu' ), '<span>' . get_search_query() . '</span>' ); ?></h3>
			</header><!-- .page-header -->
		</section>

		<section id="primary" class="content-area eight columns">
			<div id="content" class="site-content" role="main">

			<?php if ( have_posts() ) : ?>

				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'content', 'search' ); ?>

				<?php endwhile; ?>

				<?php tdblu_content_nav( 'nav-below' ); ?>

			<?php else : ?>

				<?php get_template_part( 'no-results', 'search' ); ?>

			<?php endif; ?>

			</div><!-- #content .site-content -->
		</section><!-- #primary .content-area -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>