<?php
/**
 * Custom functions that act independently of the theme templates
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 * @package tdBlu
 * @since tdBlu 1.0
 */

/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 *
 * @since tdBlu 1.0
 */
function tdblu_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'tdblu_page_menu_args' );

/**
 * Adds custom classes to the array of body classes.
 *
 * @since tdBlu 1.0
 */
function tdblu_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	return $classes;
}
add_filter( 'body_class', 'tdblu_body_classes' );

/**
 * Filter in a link to a content ID attribute for the next/previous image links on image attachment pages
 *
 * @since tdBlu 1.0
 */
function tdblu_enhanced_image_navigation( $url, $id ) {
	if ( ! is_attachment() && ! wp_attachment_is_image( $id ) )
		return $url;

	$image = get_post( $id );
	if ( ! empty( $image->post_parent ) && $image->post_parent != $id )
		$url .= '#main';

	return $url;
}
add_filter( 'attachment_link', 'tdblu_enhanced_image_navigation', 10, 2 );

/**
 * Filters wp_title to print a neat <title> tag based on what is being viewed.
 *
 * @since tdBlu 1.1
 */
function tdblu_wp_title( $title, $sep ) {
	global $page, $paged;

	if ( is_feed() )
		return $title;

	// Add the blog name
	$title .= get_bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title .= " $sep $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		$title .= " $sep " . sprintf( __( 'Page %s', 'tdblu' ), max( $paged, $page ) );

	return $title;
}
add_filter( 'wp_title', 'tdblu_wp_title', 10, 2 );

/**
 * This function counts how many attachments current post has
 *
 * @since tdBlu 1.0
 */
 function tdblu_count_attachment() {
 	global $post;
 	
 	$args = array(
   		'post_type' => 'attachment',
   		'numberposts' => -1,
   		'post_status' => null,
   		'post_parent' => $post->ID
  	);
  	
  	$attachments = get_posts( $args );
  	
  	return count($attachments);
 }